/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.views;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.views.AbstractQuantitationCompoundSelectionView;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationPeakMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.peak.StackedPeakUI;
import org.eclipse.chemclipse.swt.ui.support.AxisTitlesMassScale;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Composite;

public class QuantitationPeaksView
extends AbstractQuantitationCompoundSelectionView {
    @Inject
    private Composite parent;
    private StackedPeakUI stackedPeakUI;

    @Inject
    public QuantitationPeaksView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
    }

    @PostConstruct
    public void createControl() {
        this.stackedPeakUI = new StackedPeakUI(this.parent, 0, (IAxisTitles)new AxisTitlesMassScale());
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.stackedPeakUI.setFocus();
    }

    @Override
    public void update(IQuantitationCompoundMSD quantitationCompoundMSD, IQuantDatabase database) {
        if (this.doUpdate() && quantitationCompoundMSD != null && database != null) {
            List quantitationPeaks = database.getQuantitationPeaks(quantitationCompoundMSD);
            List<IPeakMSD> peakListMSD = this.getPeakList(quantitationPeaks);
            this.stackedPeakUI.update(peakListMSD, true);
        }
    }

    private List<IPeakMSD> getPeakList(List<IQuantitationPeakMSD> quantitationPeaks) {
        assert (quantitationPeaks != null) : "The peak documents list must be not null.";
        ArrayList<IPeakMSD> peakListMSD = new ArrayList<IPeakMSD>();
        for (IQuantitationPeakMSD quantitationPeakDocument : quantitationPeaks) {
            peakListMSD.add(quantitationPeakDocument.getReferencePeakMSD());
        }
        return peakListMSD;
    }
}

