/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.support.MassSpectrumIdentifier;
import org.eclipse.chemclipse.ux.extension.ui.provider.FileExplorerContentProvider;

public class MassSpectrumFileExplorerContentProvider
extends FileExplorerContentProvider {
    public File[] getFiles(File parentFile) {
        ArrayList<File> files = new ArrayList<File>();
        if (parentFile.isDirectory() && parentFile.canRead()) {
            File updatedParentFile = new File(parentFile.toString());
            File[] fileList = updatedParentFile.listFiles();
            if (fileList != null) {
                File[] fileArray = fileList;
                int n = fileList.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!file.isHidden()) {
                        if (file.isDirectory()) {
                            files.add(file);
                        } else if (MassSpectrumIdentifier.isMassSpectrum(file)) {
                            files.add(file);
                        }
                    }
                    ++n2;
                }
                Object[] allFiles = new File[files.size()];
                files.toArray(allFiles);
                Arrays.sort(allFiles);
                return allFiles;
            }
            return null;
        }
        return null;
    }

    public boolean hasChildren(File parentFile) {
        ArrayList<File> files = new ArrayList<File>();
        if (parentFile.isDirectory() && parentFile.canRead()) {
            if (MassSpectrumIdentifier.isMassSpectrumDirectory(parentFile)) {
                return false;
            }
            File[] fileList = parentFile.listFiles();
            if (fileList != null) {
                File[] fileArray = parentFile.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!file.isHidden()) {
                        files.add(file);
                    }
                    ++n2;
                }
                return files.size() > 0;
            }
            return false;
        }
        return false;
    }
}

