/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.quantitation;

import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;

public abstract class AbstractQuantitationEntry
implements IQuantitationEntry {
    private static final long serialVersionUID = -6312658397485712262L;
    private String name;
    private String chemicalClass = "";
    private double concentration;
    private String concentrationUnit;
    private double area;
    private String calibrationMethod = "";
    private boolean usedCrossZero = true;
    private String description = "";

    public AbstractQuantitationEntry(String name, double concentration, String concentrationUnit, double area) {
        this.name = name;
        this.concentration = concentration;
        this.concentrationUnit = concentrationUnit;
        this.area = area;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getChemicalClass() {
        return this.chemicalClass;
    }

    @Override
    public void setChemicalClass(String chemicalClass) {
        this.chemicalClass = chemicalClass;
    }

    @Override
    public double getConcentration() {
        return this.concentration;
    }

    @Override
    public String getConcentrationUnit() {
        return this.concentrationUnit;
    }

    @Override
    public double getArea() {
        return this.area;
    }

    @Override
    public String getCalibrationMethod() {
        return this.calibrationMethod;
    }

    @Override
    public void setCalibrationMethod(String calibrationMethod) {
        if (calibrationMethod != null) {
            this.calibrationMethod = calibrationMethod;
        }
    }

    @Override
    public boolean getUsedCrossZero() {
        return this.usedCrossZero;
    }

    @Override
    public void setUsedCrossZero(boolean usedCrossZero) {
        this.usedCrossZero = usedCrossZero;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        IQuantitationEntry other = (IQuantitationEntry)otherObject;
        return this.getName().equals(other.getName()) && this.getChemicalClass().equals(other.getChemicalClass()) && this.getConcentration() == other.getConcentration() && this.getConcentrationUnit().equals(other.getConcentrationUnit()) && this.getArea() == other.getArea() && this.getCalibrationMethod().equals(other.getCalibrationMethod()) && this.getUsedCrossZero() == other.getUsedCrossZero() && this.getDescription().equals(other.getDescription());
    }

    public int hashCode() {
        return 7 * this.name.hashCode() + 11 * this.chemicalClass.hashCode() + 13 * Double.valueOf(this.concentration).hashCode() + 11 * this.concentrationUnit.hashCode() + Double.valueOf(this.area).hashCode() + this.calibrationMethod.hashCode() + Boolean.valueOf(this.usedCrossZero).hashCode() + this.description.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("name=" + this.name);
        builder.append(",");
        builder.append("chemicalClass=" + this.chemicalClass);
        builder.append(",");
        builder.append("concentration=" + this.concentration);
        builder.append(",");
        builder.append("concentrationUnit=" + this.concentrationUnit);
        builder.append(",");
        builder.append("area=" + this.area);
        builder.append(",");
        builder.append("calibrationMethod=" + this.calibrationMethod);
        builder.append(",");
        builder.append("usedCrossZero=" + this.usedCrossZero);
        builder.append(",");
        builder.append("description=" + this.description);
        builder.append("]");
        return builder.toString();
    }
}

