/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.ISyncInfoTreeChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelUpdateHandler;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.internal.ui.synchronize.UnchangedResourceModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public abstract class AbstractSynchronizeModelProvider
implements ISynchronizeModelProvider,
ISyncInfoSetChangeListener,
TreeListener {
    public static final String P_VIEWER_EXPANSION_STATE = "org.eclipse.team.ui.P_VIEWER_EXPANSION_STATE";
    public static final String P_VIEWER_SELECTION_STATE = "org.eclipse.team.ui.P_VIEWER_SELECTION_STATE";
    public static final String P_VIEWER_CHECKED_STATE = "org.eclipse.team.ui.P_VIEWER_CHECKED_STATE";
    private ISynchronizeModelElement root;
    private ISynchronizePageConfiguration configuration;
    private SyncInfoSet set;
    private SynchronizeModelUpdateHandler updateHandler;
    private boolean disposed = false;
    private SynchronizePageActionGroup actionGroup;
    private ListenerList listeners;
    private static final boolean DEBUG = false;

    protected AbstractSynchronizeModelProvider(AbstractSynchronizeModelProvider parentProvider, ISynchronizeModelElement parentNode, ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        Assert.isNotNull((Object)set);
        Assert.isNotNull((Object)parentNode);
        this.root = parentNode;
        this.set = set;
        this.configuration = configuration;
        if (parentProvider == null) {
            this.updateHandler = new SynchronizeModelUpdateHandler(this);
            this.getTree().addTreeListener((TreeListener)this);
        } else {
            this.updateHandler = parentProvider.updateHandler;
            set.addSyncSetChangedListener((ISyncInfoSetChangeListener)this);
        }
    }

    private Tree getTree() {
        return (Tree)((AbstractTreeViewer)this.getViewer()).getControl();
    }

    protected AbstractSynchronizeModelProvider(ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        this(null, new UnchangedResourceModelElement(null, (IResource)ResourcesPlugin.getWorkspace().getRoot()){

            public boolean hasChildren() {
                return true;
            }
        }, configuration, set);
        SynchronizePageActionGroup actionGroup = this.getActionGroup();
        if (actionGroup != null) {
            configuration.addActionContribution(actionGroup);
        }
    }

    public final synchronized SynchronizePageActionGroup getActionGroup() {
        if (this.actionGroup == null) {
            this.actionGroup = this.createActionGroup();
        }
        return this.actionGroup;
    }

    protected SynchronizePageActionGroup createActionGroup() {
        return null;
    }

    public SyncInfoSet getSyncInfoSet() {
        return this.set;
    }

    public ISynchronizeModelElement getModelRoot() {
        return this.root;
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    public StructuredViewer getViewer() {
        ISynchronizePage page = this.configuration.getPage();
        if (page == null) {
            return null;
        }
        Viewer viewer = page.getViewer();
        if (viewer instanceof AbstractTreeViewer) {
            return (AbstractTreeViewer)viewer;
        }
        return null;
    }

    public ISynchronizeModelElement prepareInput(IProgressMonitor monitor) {
        if (this.isRootProvider()) {
            this.updateHandler.connect(monitor);
        } else {
            this.getSyncInfoSet().connect((ISyncInfoSetChangeListener)this, monitor);
        }
        return this.getModelRoot();
    }

    public String calculateProblemMarker(ISynchronizeModelElement element) {
        String property;
        block16: {
            IResource resource = element.getResource();
            property = null;
            if (resource != null && resource.exists()) {
                try {
                    IMarker[] markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, this.getLogicalModelDepth(resource));
                    int i = 0;
                    while (i < markers.length) {
                        block15: {
                            IMarker marker = markers[i];
                            try {
                                Integer severity = (Integer)marker.getAttribute("severity");
                                if (severity == null) break block15;
                                if (severity == 2) {
                                    property = "org.eclipse.team.ui.error";
                                    break;
                                }
                                if (severity == 1) {
                                    property = "org.eclipse.team.ui.warning";
                                }
                            }
                            catch (CoreException e) {
                                if (!resource.exists()) {
                                    property = null;
                                    break;
                                }
                                if (!marker.exists()) break block15;
                                TeamPlugin.log((CoreException)e);
                            }
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    if (!resource.isAccessible() || e.getStatus().getCode() == 368 || e.getStatus().getCode() == 372) break block16;
                    TeamPlugin.log((CoreException)e);
                }
            } else if (resource == null) {
                IDiffElement[] children = element.getChildren();
                int i = 0;
                while (i < children.length) {
                    IDiffElement child = children[i];
                    if (child instanceof ISynchronizeModelElement) {
                        ISynchronizeModelElement childElement = (ISynchronizeModelElement)child;
                        if (childElement.getProperty("org.eclipse.team.ui.error")) {
                            property = "org.eclipse.team.ui.error";
                            break;
                        }
                        if (childElement.getProperty("org.eclipse.team.ui.warning")) {
                            property = "org.eclipse.team.ui.warning";
                        }
                    }
                    ++i;
                }
            }
        }
        return property;
    }

    protected int getLogicalModelDepth(IResource resource) {
        return 2;
    }

    protected void queueForLabelUpdate(ISynchronizeModelElement diffNode) {
        this.updateHandler.queueForLabelUpdate(diffNode);
    }

    protected void reset() {
        if (this.isRootProvider() && this.hasViewerState()) {
            this.saveViewerState();
        }
        this.clearModelObjects(this.getModelRoot());
        this.buildModelObjects(this.getModelRoot());
        ISynchronizeModelElement root = this.getModelRoot();
        if (root instanceof SynchronizeModelElement) {
            ((SynchronizeModelElement)root).fireChanges();
        }
        if (Utils.canUpdateViewer(this.getViewer())) {
            this.refreshModelRoot();
        } else if (!this.updateHandler.isPerformingBackgroundUpdate()) {
            Utils.asyncExec(new Runnable(){

                public void run() {
                    AbstractSynchronizeModelProvider.this.refreshModelRoot();
                }
            }, this.getViewer());
        }
    }

    private void refreshModelRoot() {
        StructuredViewer viewer = this.getViewer();
        if (viewer != null && !viewer.getControl().isDisposed()) {
            try {
                viewer.getControl().setRedraw(false);
                if (this.isRootProvider() || this.getModelRoot().getParent() == null) {
                    viewer.refresh();
                } else {
                    this.addToViewer(this.getModelRoot());
                }
                if (this.isRootProvider()) {
                    this.restoreViewerState();
                }
            }
            finally {
                viewer.getControl().setRedraw(true);
            }
        }
    }

    protected abstract IDiffElement[] buildModelObjects(ISynchronizeModelElement var1);

    protected abstract boolean hasViewerState();

    protected IResource[] getExpandedResources() {
        HashSet<IResource> expanded = new HashSet<IResource>();
        IResource[] savedExpansionState = this.getCachedResources(P_VIEWER_EXPANSION_STATE);
        int i = 0;
        while (i < savedExpansionState.length) {
            IResource resource = savedExpansionState[i];
            expanded.add(resource);
            ++i;
        }
        StructuredViewer viewer = this.getViewer();
        Object[] objects = ((AbstractTreeViewer)viewer).getVisibleExpandedElements();
        IResource[] currentExpansionState = this.getResources(objects);
        int i2 = 0;
        while (i2 < currentExpansionState.length) {
            IResource resource = currentExpansionState[i2];
            expanded.add(resource);
            ++i2;
        }
        return expanded.toArray(new IResource[expanded.size()]);
    }

    protected IResource[] getSelectedResources() {
        StructuredViewer viewer = this.getViewer();
        return this.getResources(((IStructuredSelection)viewer.getSelection()).toArray());
    }

    protected IResource[] getCheckedResources() {
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof CheckboxTreeViewer) {
            return this.getResources(((CheckboxTreeViewer)viewer).getCheckedElements());
        }
        return new IResource[0];
    }

    protected void expandResources(IResource[] resources) {
        HashSet<ISynchronizeModelElement> expandedElements = new HashSet<ISynchronizeModelElement>();
        StructuredViewer viewer = this.getViewer();
        int j = 0;
        while (j < resources.length) {
            IResource resource = resources[j];
            ISynchronizeModelElement[] elements = this.getModelObjects(resource);
            if (elements.length == 1) {
                int i = 0;
                while (i < elements.length) {
                    ISynchronizeModelElement element = elements[i];
                    while (element != null) {
                        expandedElements.add(element);
                        element = (ISynchronizeModelElement)element.getParent();
                    }
                    ++i;
                }
            }
            ++j;
        }
        if (!expandedElements.isEmpty()) {
            ((AbstractTreeViewer)viewer).setExpandedElements(expandedElements.toArray());
        }
    }

    protected IResource[] getResources(Object[] objects) {
        HashSet<IResource> result = new HashSet<IResource>();
        if (objects.length > 0) {
            int i = 0;
            while (i < objects.length) {
                IResource resource;
                if (objects[i] instanceof ISynchronizeModelElement && (resource = ((ISynchronizeModelElement)objects[i]).getResource()) != null) {
                    result.add(resource);
                }
                ++i;
            }
        }
        return result.toArray(new IResource[result.size()]);
    }

    private void clearResourceCache(String configProperty) {
        this.getConfiguration().setProperty(configProperty, null);
    }

    private void cacheResources(IResource[] resources, String configProperty) {
        if (resources.length > 0) {
            ISynchronizePageConfiguration config = this.getConfiguration();
            ArrayList<String> paths = new ArrayList<String>();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                String path = resource.getFullPath().toString();
                if (resource.getType() != 1 && path.charAt(path.length() - 1) != '/') {
                    path = String.valueOf(path) + '/';
                }
                paths.add(path);
                ++i;
            }
            config.setProperty(configProperty, paths);
        } else {
            this.clearResourceCache(configProperty);
        }
    }

    private IResource[] getCachedResources(String configProperty) {
        List paths = (List)this.getConfiguration().getProperty(configProperty);
        if (paths == null) {
            return new IResource[0];
        }
        IWorkspaceRoot container = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IResource> resources = new ArrayList<IResource>();
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            IResource resource = this.getResourceForPath((IContainer)container, path);
            if (resource == null) continue;
            resources.add(resource);
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    protected void saveViewerState() {
        final StructuredViewer viewer = this.getViewer();
        if (viewer != null && !viewer.getControl().isDisposed() && viewer instanceof AbstractTreeViewer) {
            final boolean storeChecks = ((SynchronizePageConfiguration)this.configuration).getViewerStyle() == 1;
            final IResource[][] expandedResources = new IResource[1][0];
            final IResource[][] selectedResources = new IResource[1][0];
            final IResource[][] checkedResources = new IResource[1][0];
            viewer.getControl().getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (viewer != null && !viewer.getControl().isDisposed()) {
                        expandedResources[0] = AbstractSynchronizeModelProvider.this.getExpandedResources();
                        selectedResources[0] = AbstractSynchronizeModelProvider.this.getSelectedResources();
                        if (storeChecks) {
                            checkedResources[0] = AbstractSynchronizeModelProvider.this.getCheckedResources();
                        }
                    }
                }
            });
            this.cacheResources(expandedResources[0], P_VIEWER_EXPANSION_STATE);
            this.cacheResources(selectedResources[0], P_VIEWER_SELECTION_STATE);
            if (storeChecks) {
                this.cacheResources(checkedResources[0], P_VIEWER_CHECKED_STATE);
            }
        }
    }

    protected void restoreViewerState() {
        StructuredViewer viewer = this.getViewer();
        if (viewer != null && !viewer.getControl().isDisposed() && viewer instanceof AbstractTreeViewer) {
            IResource[] resourcesToExpand = this.getCachedResources(P_VIEWER_EXPANSION_STATE);
            IResource[] resourcesToSelect = this.getCachedResources(P_VIEWER_SELECTION_STATE);
            if (((SynchronizePageConfiguration)this.configuration).getViewerStyle() == 1) {
                IResource[] resourcesToCheck = this.getCachedResources(P_VIEWER_CHECKED_STATE);
                this.checkResources(resourcesToCheck);
            }
            this.expandResources(resourcesToExpand);
            this.selectResources(resourcesToSelect);
        }
    }

    protected void selectResources(IResource[] resourcesToSelect) {
        StructuredViewer viewer = this.getViewer();
        ArrayList<ISynchronizeModelElement> selectedElements = new ArrayList<ISynchronizeModelElement>();
        int i = 0;
        while (i < resourcesToSelect.length) {
            IResource resource = resourcesToSelect[i];
            ISynchronizeModelElement[] elements = this.getModelObjects(resource);
            if (elements.length == 1) {
                selectedElements.add(elements[0]);
            }
            ++i;
        }
        if (!selectedElements.isEmpty()) {
            viewer.setSelection((ISelection)new StructuredSelection(selectedElements));
        }
    }

    protected void checkResources(IResource[] resourcesToCheck) {
        HashSet<ISynchronizeModelElement> checkedElements = new HashSet<ISynchronizeModelElement>();
        StructuredViewer viewer = this.getViewer();
        if (!(viewer instanceof CheckboxTreeViewer)) {
            return;
        }
        int j = 0;
        while (j < resourcesToCheck.length) {
            ISynchronizeModelElement[] elements;
            IResource resource = resourcesToCheck[j];
            if (resource.getType() == 1 && (elements = this.getModelObjects(resource)).length == 1) {
                int i = 0;
                while (i < elements.length) {
                    ISynchronizeModelElement element = elements[i];
                    checkedElements.add(element);
                    ++i;
                }
            }
            ++j;
        }
        if (!checkedElements.isEmpty()) {
            ((CheckboxTreeViewer)viewer).setCheckedElements(checkedElements.toArray());
        }
    }

    private IResource getResourceForPath(IContainer container, String path) {
        Object resource = container.findMember(path, true);
        if (resource == null) {
            try {
                resource = path.endsWith(Character.toString('/')) ? container.getFolder((IPath)new Path(null, path)) : container.getFile((IPath)new Path(null, path));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return resource;
    }

    public void treeCollapsed(TreeEvent e) {
        this.clearResourceCache(P_VIEWER_EXPANSION_STATE);
    }

    public void treeExpanded(TreeEvent e) {
        this.clearResourceCache(P_VIEWER_EXPANSION_STATE);
    }

    protected abstract ISynchronizeModelElement[] getModelObjects(IResource var1);

    public void saveState() {
        this.saveViewerState();
    }

    protected void propogateConflictState(ISynchronizeModelElement element, boolean clear) {
        boolean wasConflict;
        boolean isConflict = clear ? false : this.isConflicting(element);
        if (isConflict != (wasConflict = element.getProperty("org.eclipse.team.ui.conflict"))) {
            element.setPropertyToRoot("org.eclipse.team.ui.conflict", isConflict);
            this.updateHandler.updateParentLabels(element);
        }
    }

    protected boolean isConflicting(ISynchronizeModelElement element) {
        return (element.getKind() & 0xC) == 12;
    }

    public void dispose() {
        if (this.isRootProvider()) {
            this.updateHandler.dispose();
            this.getTree().removeTreeListener((TreeListener)this);
        } else {
            this.set.removeSyncSetChangedListener((ISyncInfoSetChangeListener)this);
        }
        if (this.actionGroup != null) {
            Utils.syncExec(new Runnable(){

                public void run() {
                    AbstractSynchronizeModelProvider.this.actionGroup.dispose();
                }
            }, this.getViewer());
        }
        this.disposed = true;
    }

    private boolean isRootProvider() {
        return this.updateHandler.getProvider() == this;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public abstract ISynchronizeModelElement[] getClosestExistingParents(IResource var1);

    protected void handleChanges(ISyncInfoTreeChangeEvent event, IProgressMonitor monitor) {
        this.handleResourceChanges(event);
        this.handleResourceRemovals(event);
        this.handleResourceAdditions(event);
    }

    protected abstract void handleResourceAdditions(ISyncInfoTreeChangeEvent var1);

    protected abstract void handleResourceChanges(ISyncInfoTreeChangeEvent var1);

    protected abstract void handleResourceRemovals(ISyncInfoTreeChangeEvent var1);

    public void syncInfoChanged(final ISyncInfoSetChangeEvent event, final IProgressMonitor monitor) {
        if (!(event instanceof ISyncInfoTreeChangeEvent)) {
            this.reset();
        } else {
            this.updateHandler.runViewUpdate(new Runnable(){

                public void run() {
                    AbstractSynchronizeModelProvider.this.handleChanges((ISyncInfoTreeChangeEvent)event, monitor);
                }
            }, true);
        }
    }

    public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
    }

    public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
        this.reset();
    }

    protected void addToViewer(ISynchronizeModelElement node) {
        this.propogateConflictState(node, false);
        String property = this.calculateProblemMarker(node);
        if (property != null) {
            node.setProperty(property, true);
            this.propogateMarkerPropertyToParent(node, property);
        }
        if (Utils.canUpdateViewer(this.getViewer())) {
            this.doAdd((SynchronizeModelElement)node.getParent(), node);
        }
        this.updateHandler.nodeAdded(node, this);
    }

    private void propogateMarkerPropertyToParent(ISynchronizeModelElement node, String property) {
        ISynchronizeModelElement parent = (ISynchronizeModelElement)node.getParent();
        if (parent != null && !parent.getProperty(property) && !parent.getProperty("org.eclipse.team.ui.error")) {
            parent.setProperty(property, true);
            this.propogateMarkerPropertyToParent(parent, property);
        }
    }

    protected void removeFromViewer(ISynchronizeModelElement[] nodes) {
        ArrayList<ISynchronizeModelElement> rootsToClear = new ArrayList<ISynchronizeModelElement>();
        int i = 0;
        while (i < nodes.length) {
            ISynchronizeModelElement node = nodes[i];
            ISynchronizeModelElement rootToClear = this.getRootToClear(node);
            this.propogateConflictState(rootToClear, true);
            this.clearModelObjects(rootToClear);
            rootsToClear.add(rootToClear);
            ++i;
        }
        ISynchronizeModelElement[] roots = rootsToClear.toArray(new ISynchronizeModelElement[rootsToClear.size()]);
        if (Utils.canUpdateViewer(this.getViewer())) {
            this.doRemove(roots);
        }
        int i2 = 0;
        while (i2 < roots.length) {
            ISynchronizeModelElement element = roots[i2];
            this.updateHandler.nodeRemoved(element, this);
            ++i2;
        }
    }

    protected final void clearModelObjects(ISynchronizeModelElement node) {
        ISynchronizeModelElement rootToClear = this.getRootToClear(node);
        this.recursiveClearModelObjects(rootToClear);
        if (node == this.getModelRoot()) {
            IDiffElement[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                IDiffElement element = children[i];
                ((SynchronizeModelElement)node).remove(element);
                ++i;
            }
        } else {
            SynchronizeModelElement parent = (SynchronizeModelElement)node.getParent();
            if (parent != null) {
                parent.remove((IDiffElement)node);
            }
        }
    }

    protected void recursiveClearModelObjects(ISynchronizeModelElement node) {
        IDiffElement[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            IDiffElement element = children[i];
            if (element instanceof ISynchronizeModelElement) {
                ISynchronizeModelElement sme = (ISynchronizeModelElement)element;
                ISynchronizeModelProvider provider = this.getProvider(sme);
                if (provider != null && provider instanceof AbstractSynchronizeModelProvider) {
                    ((AbstractSynchronizeModelProvider)provider).recursiveClearModelObjects(sme);
                } else {
                    this.recursiveClearModelObjects(sme);
                }
            }
            ++i;
        }
        if (node != this.getModelRoot()) {
            this.updateHandler.modelObjectCleared(node);
        }
    }

    private ISynchronizeModelElement getRootToClear(ISynchronizeModelElement node) {
        if (node == this.getModelRoot()) {
            return node;
        }
        ISynchronizeModelElement parent = (ISynchronizeModelElement)node.getParent();
        if (parent != null && parent != this.getModelRoot() && !this.isOutOfSync(parent) && parent.getChildren().length == 1) {
            return this.getRootToClear(parent);
        }
        return node;
    }

    protected boolean isOutOfSync(ISynchronizeModelElement node) {
        SyncInfo info = Utils.getSyncInfo(node);
        return info != null && info.getKind() != 0;
    }

    protected boolean isOutOfSync(IResource resource) {
        SyncInfo info = this.getSyncInfoSet().getSyncInfo(resource);
        return info != null && info.getKind() != 0;
    }

    protected ISynchronizeModelProvider getProvider(ISynchronizeModelElement element) {
        return this;
    }

    protected void doAdd(ISynchronizeModelElement parent, ISynchronizeModelElement element) {
        this.updateHandler.doAdd(parent, element);
    }

    protected void doRemove(ISynchronizeModelElement[] elements) {
        AbstractTreeViewer viewer = (AbstractTreeViewer)this.getViewer();
        try {
            viewer.remove((Object[])elements);
        }
        catch (SWTException e) {
            TeamUIPlugin.log(4, "An error occurred removing elements from the synchronize view", e);
        }
    }

    protected void nodeAdded(ISynchronizeModelElement node, AbstractSynchronizeModelProvider provider) {
    }

    protected void nodeRemoved(ISynchronizeModelElement node, AbstractSynchronizeModelProvider provider) {
    }

    public void modelObjectCleared(ISynchronizeModelElement node) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        AbstractSynchronizeModelProvider abstractSynchronizeModelProvider = this;
        synchronized (abstractSynchronizeModelProvider) {
            if (this.listeners == null) {
                this.listeners = new ListenerList(1);
            }
            this.listeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (this.listeners != null) {
            AbstractSynchronizeModelProvider abstractSynchronizeModelProvider = this;
            synchronized (abstractSynchronizeModelProvider) {
                this.listeners.remove((Object)listener);
                if (this.listeners.isEmpty()) {
                    this.listeners = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChange(String key, Object oldValue, Object newValue) {
        Object[] allListeners;
        AbstractSynchronizeModelProvider abstractSynchronizeModelProvider = this;
        synchronized (abstractSynchronizeModelProvider) {
            allListeners = this.listeners.getListeners();
        }
        final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, key, oldValue, newValue);
        int i = 0;
        while (i < allListeners.length) {
            final IPropertyChangeListener listener = (IPropertyChangeListener)allListeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.propertyChange(event);
                }
            });
            ++i;
        }
    }

    public void waitUntilDone(IProgressMonitor monitor) {
        monitor.worked(1);
        while (this.updateHandler.getEventHandlerJob().getState() != 0) {
            monitor.worked(1);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            Policy.checkCanceled(monitor);
        }
        monitor.worked(1);
    }

    public String toString() {
        String name2;
        ISynchronizeModelElement element = this.getModelRoot();
        String name = this.getClass().getName();
        int index = name.lastIndexOf(".");
        if (index != -1) {
            name = name.substring(index + 1);
        }
        if ((name2 = element.getName()).length() == 0) {
            name2 = "/";
        }
        return String.valueOf(name) + ": " + name2;
    }

    public void performUpdate(IWorkspaceRunnable runnable, boolean preserveExpansion, boolean runInUIThread) {
        this.updateHandler.performUpdate(runnable, preserveExpansion, runInUIThread);
    }
}

