/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.aggregation;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.impl.aggregation.AggrRegistry;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateCalculator;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.eclipse.birt.data.engine.impl.aggregation.JSAggrValueObject;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Scriptable;

public final class AggregateTable {
    private List aggrExprInfoList;
    private List groupDefns;
    private Scriptable scope;
    private BaseQuery baseQuery;
    private String tempDir;
    private static Logger logger = Logger.getLogger(AggregateTable.class.getName());
    private AggregateCalculator currentCalculator;

    public AggregateTable(String tempDir) {
        logger.entering(AggregateTable.class.getName(), "AggregateTable");
        this.aggrExprInfoList = new ArrayList();
        this.tempDir = tempDir;
        logger.exiting(AggregateTable.class.getName(), "AggregateTable");
    }

    public AggregateTable(String tempDir, Scriptable scope, List groupDefns) {
        this(tempDir);
        Object[] params = new Object[]{tempDir, scope, groupDefns};
        logger.entering(AggregateTable.class.getName(), "AggregateTable", params);
        this.groupDefns = groupDefns;
        this.scope = scope;
        logger.exiting(AggregateTable.class.getName(), "AggregateTable");
    }

    public AggregateTable(String tempDir, BaseQuery query) {
        this(tempDir);
        logger.entering(AggregateTable.class.getName(), "AggregateTable", query);
        this.baseQuery = query;
        logger.exiting(AggregateTable.class.getName(), "AggregateTable");
    }

    public AggregateRegistry getAggrRegistry(int groupLevel, int calculationLevel, boolean isDetailedRow, ScriptContext cx) throws DataException {
        AggrRegistry aggrRegistry = new AggrRegistry(groupLevel, calculationLevel, isDetailedRow, cx);
        aggrRegistry.prepare(this.groupDefns, this.scope, this.baseQuery, this.aggrExprInfoList);
        return aggrRegistry;
    }

    public void calculate(IResultIterator odiResult, Scriptable scope, ScriptContext cx) throws DataException {
        this.currentCalculator = new AggregateCalculator(this.tempDir, this.aggrExprInfoList, odiResult);
        this.currentCalculator.calculate(scope, cx);
    }

    public void calculate(IResultIterator odiResult, Scriptable scope, ScriptContext cx, JSAggrValueObject aggrValue) throws DataException {
        this.currentCalculator = new AggregateCalculator(this.tempDir, this.aggrExprInfoList, odiResult);
        this.currentCalculator.calculate(scope, cx);
    }

    public Scriptable getJSAggrValueObject() {
        if (this.currentCalculator == null) {
            return null;
        }
        return this.currentCalculator.getJSAggrValueObject();
    }
}

