/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram;

import java.io.File;
import java.io.IOException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io.ProxyReaderMSD;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.IVendorScan;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.IVendorScanProxy;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.VendorIon;
import org.eclipse.chemclipse.msd.model.core.AbstractVendorMassSpectrumProxy;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransitionSettings;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class VendorScanProxy
extends AbstractVendorMassSpectrumProxy
implements IVendorScanProxy {
    private static final long serialVersionUID = 8949336542952337617L;
    private static final Logger logger = Logger.getLogger(VendorScanProxy.class);
    private File file;
    private int offset;
    private String version;
    private IIonTransitionSettings ionTransitionSettings;

    public VendorScanProxy(File file, int offset, String version, IIonTransitionSettings ionTransitionSettings) {
        this.file = file;
        this.offset = offset;
        this.version = version;
        this.ionTransitionSettings = ionTransitionSettings;
    }

    public int getMaxPossibleIons() {
        return 65535;
    }

    public int getMinPossibleRetentionTime() {
        return 0;
    }

    public int getMaxPossibleRetentionTime() {
        return Integer.MAX_VALUE;
    }

    public void importIons() {
        try {
            ProxyReaderMSD scanProxyReaderMSD = new ProxyReaderMSD();
            scanProxyReaderMSD.readMassSpectrum(this.file, this.offset, this.version, this, this.ionTransitionSettings, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
    }

    public IVendorScan makeDeepCopy() throws CloneNotSupportedException {
        IVendorScanProxy massSpectrum = (IVendorScanProxy)super.clone();
        for (IIon ion : this.getIons()) {
            try {
                VendorIon chemClipseIon = new VendorIon(ion.getIon(), ion.getAbundance());
                massSpectrum.addIon((IIon)chemClipseIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        return massSpectrum;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.makeDeepCopy();
    }
}

