/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.twod.hull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math3.geometry.euclidean.twod.Line;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.euclidean.twod.hull.AbstractConvexHullGenerator2D;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

public class MonotoneChain
extends AbstractConvexHullGenerator2D {
    public MonotoneChain() {
        this(false);
    }

    public MonotoneChain(boolean includeCollinearPoints) {
        super(includeCollinearPoints);
    }

    public MonotoneChain(boolean includeCollinearPoints, double tolerance) {
        super(includeCollinearPoints, tolerance);
    }

    @Override
    public Collection<Vector2D> findHullVertices(Collection<Vector2D> points) {
        ArrayList<Vector2D> pointsSortedByXAxis = new ArrayList<Vector2D>(points);
        Collections.sort(pointsSortedByXAxis, new Comparator<Vector2D>(){

            @Override
            public int compare(Vector2D o1, Vector2D o2) {
                double tolerance = MonotoneChain.this.getTolerance();
                int diff = Precision.compareTo(o1.getX(), o2.getX(), tolerance);
                if (diff == 0) {
                    return Precision.compareTo(o1.getY(), o2.getY(), tolerance);
                }
                return diff;
            }
        });
        ArrayList<Vector2D> lowerHull = new ArrayList<Vector2D>();
        for (Vector2D p : pointsSortedByXAxis) {
            this.updateHull(p, lowerHull);
        }
        ArrayList<Vector2D> upperHull = new ArrayList<Vector2D>();
        int idx = pointsSortedByXAxis.size() - 1;
        while (idx >= 0) {
            Vector2D p = (Vector2D)pointsSortedByXAxis.get(idx);
            this.updateHull(p, upperHull);
            --idx;
        }
        ArrayList<Vector2D> hullVertices = new ArrayList<Vector2D>(lowerHull.size() + upperHull.size() - 2);
        int idx2 = 0;
        while (idx2 < lowerHull.size() - 1) {
            hullVertices.add((Vector2D)lowerHull.get(idx2));
            ++idx2;
        }
        idx2 = 0;
        while (idx2 < upperHull.size() - 1) {
            hullVertices.add((Vector2D)upperHull.get(idx2));
            ++idx2;
        }
        if (hullVertices.isEmpty() && !lowerHull.isEmpty()) {
            hullVertices.add((Vector2D)lowerHull.get(0));
        }
        return hullVertices;
    }

    /*
     * Unable to fully structure code
     */
    private void updateHull(Vector2D point, List<Vector2D> hull) {
        tolerance = this.getTolerance();
        if (hull.size() != 1 || !((p1 = hull.get(0)).distance(point) < tolerance)) ** GOTO lbl25
        return;
lbl-1000:
        // 1 sources

        {
            size = hull.size();
            p1 = hull.get(size - 2);
            offset = new Line(p1, p2 = hull.get(size - 1), tolerance).getOffset(point);
            if (FastMath.abs(offset) < tolerance) {
                distanceToCurrent = p1.distance(point);
                if (distanceToCurrent < tolerance || p2.distance(point) < tolerance) {
                    return;
                }
                distanceToLast = p1.distance(p2);
                if (this.isIncludeCollinearPoints()) {
                    index = distanceToCurrent < distanceToLast ? size - 1 : size;
                    hull.add(index, point);
                } else if (distanceToCurrent > distanceToLast) {
                    hull.remove(size - 1);
                    hull.add(point);
                }
                return;
            }
            if (!(offset > 0.0)) break;
            hull.remove(size - 1);
lbl25:
            // 2 sources

            ** while (hull.size() >= 2)
        }
lbl26:
        // 2 sources

        hull.add(point);
    }
}

