/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.figures;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.util.Preferences;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class Legend
extends RectangleFigure {
    private static final int ICON_WIDTH = 25;
    private static final int INNER_GAP = 2;
    private static final int OUT_GAP = 5;
    private final Color BLACK_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_BLACK);
    private final List<Trace> traceList = new ArrayList<Trace>();

    public Legend(IXYGraph xyGraph) {
        this((XYGraph)xyGraph);
    }

    @Deprecated
    public Legend(XYGraph xyGraph) {
        xyGraph.getPlotArea().addPropertyChangeListener("background_color", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Legend.this.setBackgroundColor((Color)evt.getNewValue());
            }
        });
        this.setBackgroundColor(xyGraph.getPlotArea().getBackgroundColor());
        this.setForegroundColor(this.BLACK_COLOR);
        this.setOpaque(false);
        this.setOutline(true);
    }

    public void addTrace(Trace trace) {
        this.traceList.add(trace);
    }

    public boolean removeTrace(Trace trace) {
        return this.traceList.remove(trace);
    }

    protected void outlineShape(Graphics graphics) {
        graphics.setForegroundColor(this.traceList.get(0).getYAxis().getForegroundColor());
        super.outlineShape(graphics);
    }

    protected void fillShape(Graphics graphics) {
        if (!((XYGraph)this.getParent()).isTransparent()) {
            super.fillShape(graphics);
        }
        int hPos = this.bounds.x + 2;
        int vPos = this.bounds.y + 2;
        int i = 0;
        for (Trace trace : this.traceList) {
            int hwidth = 32 + FigureUtilities.getTextExtents((String)trace.getName(), (Font)this.getFont()).width;
            int hEnd = hPos + hwidth;
            if (hEnd > this.bounds.x + this.bounds.width && i > 0) {
                hPos = this.bounds.x + 2;
                vPos += 27;
                hEnd = hPos + hwidth;
            }
            this.drawTraceLagend(trace, graphics, hPos, vPos);
            hPos = hEnd;
            ++i;
        }
    }

    private void drawTraceLagend(Trace trace, Graphics graphics, int hPos, int vPos) {
        graphics.pushState();
        if (Preferences.useAdvancedGraphics()) {
            graphics.setAntialias(1);
        }
        graphics.setForegroundColor(trace.getTraceColor());
        int maxSize = (double)trace.getPointSize() > Math.floor(10.0) ? (int)Math.floor(20.0) : trace.getPointSize();
        switch (trace.getTraceType()) {
            case BAR: {
                trace.drawLine(graphics, new Point(hPos + 12, vPos + maxSize / 2), new Point(hPos + 12, vPos + 25));
                trace.drawPoint(graphics, new Point(hPos + 12, vPos + maxSize / 2));
                break;
            }
            case LINE_AREA: {
                graphics.drawPolyline(new int[]{hPos, vPos + 12, hPos + 12, vPos + maxSize / 2, hPos + 25 - 1, vPos + 12});
            }
            case AREA: {
                graphics.setBackgroundColor(trace.getTraceColor());
                if (Preferences.useAdvancedGraphics()) {
                    graphics.setAlpha(trace.getAreaAlpha());
                }
                graphics.fillPolygon(new int[]{hPos, vPos + 12, hPos + 12, vPos + maxSize / 2, hPos + 25, vPos + 12, hPos + 25, vPos + 25, hPos, vPos + 25});
                if (Preferences.useAdvancedGraphics()) {
                    graphics.setAlpha(255);
                }
                trace.drawPoint(graphics, new Point(hPos + 12, vPos + maxSize / 2));
                break;
            }
            default: {
                trace.drawLine(graphics, new Point(hPos, vPos + 12), new Point(hPos + 25, vPos + 12));
                trace.drawPoint(graphics, new Point(hPos + 12, vPos + 12));
            }
        }
        graphics.drawText(trace.getName(), hPos + 25 + 2, vPos + 12 - FigureUtilities.getTextExtents((String)trace.getName(), (Font)this.getFont()).height / 2);
        graphics.popState();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        int maxWidth = 0;
        int hEnd = 2;
        int height = 27;
        for (Trace trace : this.traceList) {
            if ((hEnd = hEnd + 5 + 25 + 2 + FigureUtilities.getTextExtents((String)trace.getName(), (Font)this.getFont()).width) > wHint) {
                hEnd = 34 + FigureUtilities.getTextExtents((String)trace.getName(), (Font)this.getFont()).width;
                height += 27;
            }
            if (maxWidth >= hEnd) continue;
            maxWidth = hEnd;
        }
        return new Dimension(maxWidth, height);
    }

    public List<Trace> getTraceList() {
        return this.traceList;
    }
}

