/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.parts;

import java.net.URL;
import javafx.application.Platform;
import javafx.embed.swt.FXCanvas;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.util.BuilderFactory;
import javax.annotation.PostConstruct;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.Activator;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;

public class PartTic {
    private static final Logger logger = Logger.getLogger(PartTic.class);
    private FXCanvas fxCanvas;

    @PostConstruct
    public void createComposite(Composite parent) {
        this.init(parent);
    }

    private void createScene() {
        try {
            Path path = new Path("fxml/FXML.fxml");
            URL location = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)path, null);
            FXMLLoader fXMLLoader = new FXMLLoader();
            fXMLLoader.setLocation(location);
            fXMLLoader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
            Parent root = (Parent)fXMLLoader.load(location.openStream());
            Scene scene = new Scene(root);
            scene.getStylesheets().add((Object)"css/fxml.css");
            this.fxCanvas.setScene(scene);
            fXMLLoader.getController();
            logger.debug((Object)"Initializing FX successful");
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void init(Composite parent) {
        this.fxCanvas = new FXCanvas(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                this.getScene().getWindow().sizeToScene();
                int width = (int)this.getScene().getWidth();
                int height = (int)this.getScene().getHeight();
                return new Point(width, height);
            }
        };
        Platform.setImplicitExit((boolean)false);
        Platform.runLater(() -> this.createScene());
    }
}

