/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.processing.IPeakFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.processing.PeakFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.result.IPeakFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.PeakFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IPeakFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.AbstractPeakFilter;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.calculator.FilterSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.settings.ISnipPeakFilterSettings;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakFilter
extends AbstractPeakFilter {
    private static final String DESCRIPTION = "SNIP Filter Peak(s) Mass Spectra";

    public IPeakFilterProcessingInfo applyFilter(List<IPeakMSD> peaks, IPeakFilterSettings peakFilterSettings, IProgressMonitor monitor) {
        PeakFilterProcessingInfo processingInfo = new PeakFilterProcessingInfo();
        processingInfo.addMessages(this.validate(peaks, peakFilterSettings));
        if (processingInfo.hasErrorMessages()) {
            return processingInfo;
        }
        if (peakFilterSettings instanceof ISnipPeakFilterSettings) {
            ISnipPeakFilterSettings snipPeakFilterSettings = (ISnipPeakFilterSettings)peakFilterSettings;
            FilterSupplier filterSupplier = new FilterSupplier();
            ArrayList<IScanMSD> massSpectra = new ArrayList<IScanMSD>();
            for (IPeakMSD peakMSD : peaks) {
                massSpectra.add((IScanMSD)peakMSD.getPeakModel().getPeakMassSpectrum());
            }
            int iterations = snipPeakFilterSettings.getIterations();
            int transitions = snipPeakFilterSettings.getTransitions();
            double magnificationFactor = snipPeakFilterSettings.getMagnificationFactor();
            filterSupplier.applySnipFilter(massSpectra, iterations, transitions, magnificationFactor, monitor);
            processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, DESCRIPTION, "The mass spectrum has been optimized successfully."));
        } else {
            processingInfo.addErrorMessage(DESCRIPTION, "The filter settings instance is not a type of: " + ISnipPeakFilterSettings.class);
        }
        PeakFilterResult peakFilterResult = new PeakFilterResult(ResultStatus.OK, "The SNIP filter has been applied successfully.");
        processingInfo.setPeakFilterResult((IPeakFilterResult)peakFilterResult);
        return processingInfo;
    }

    public IPeakFilterProcessingInfo applyFilter(IPeakMSD peak, IPeakFilterSettings peakFilterSettings, IProgressMonitor monitor) {
        ArrayList<IPeakMSD> peaks = new ArrayList<IPeakMSD>();
        peaks.add(peak);
        return this.applyFilter(peaks, peakFilterSettings, monitor);
    }

    public IPeakFilterProcessingInfo applyFilter(IPeakMSD peak, IProgressMonitor monitor) {
        ArrayList<IPeakMSD> peaks = new ArrayList<IPeakMSD>();
        peaks.add(peak);
        ISnipPeakFilterSettings peakFilterSettings = PreferenceSupplier.getPeakFilterSettings();
        return this.applyFilter(peaks, (IPeakFilterSettings)peakFilterSettings, monitor);
    }

    public IPeakFilterProcessingInfo applyFilter(List<IPeakMSD> peaks, IProgressMonitor monitor) {
        ISnipPeakFilterSettings peakFilterSettings = PreferenceSupplier.getPeakFilterSettings();
        return this.applyFilter(peaks, (IPeakFilterSettings)peakFilterSettings, monitor);
    }

    public IPeakFilterProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IPeakFilterSettings peakFilterSettings, IProgressMonitor monitor) {
        PeakFilterProcessingInfo processingInfo = new PeakFilterProcessingInfo();
        processingInfo.addMessages(this.validate(chromatogramSelection, peakFilterSettings));
        if (processingInfo.hasErrorMessages()) {
            return processingInfo;
        }
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        List peakList = chromatogram.getPeaks(chromatogramSelection);
        ArrayList<IPeakMSD> peaks = new ArrayList<IPeakMSD>();
        for (IChromatogramPeakMSD peak : peakList) {
            peaks.add((IPeakMSD)peak);
        }
        return this.applyFilter(peaks, peakFilterSettings, monitor);
    }

    public IPeakFilterProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) {
        ISnipPeakFilterSettings peakFilterSettings = PreferenceSupplier.getPeakFilterSettings();
        return this.applyFilter(chromatogramSelection, (IPeakFilterSettings)peakFilterSettings, monitor);
    }
}

