/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CallSearchResultCollector {
    private Map<String, MethodCall> fCalledMembers = this.createCalledMethodsData();

    public Map<String, MethodCall> getCallers() {
        return this.fCalledMembers;
    }

    protected void addMember(IMember member, IMember calledMember, int start, int end) {
        this.addMember(member, calledMember, start, end, -1);
    }

    protected void addMember(IMember member, IMember calledMember, int start, int end, int lineNumber) {
        if (member != null && calledMember != null && !this.isIgnored(calledMember)) {
            MethodCall methodCall = this.fCalledMembers.get(calledMember.getHandleIdentifier());
            if (methodCall == null) {
                methodCall = new MethodCall(calledMember);
                this.fCalledMembers.put(calledMember.getHandleIdentifier(), methodCall);
            }
            methodCall.addCallLocation(new CallLocation(member, calledMember, start, end, lineNumber));
        }
    }

    protected Map<String, MethodCall> createCalledMethodsData() {
        return new HashMap<String, MethodCall>();
    }

    private boolean isIgnored(IMember enclosingElement) {
        String fullyQualifiedName = this.getTypeOfElement(enclosingElement).getFullyQualifiedName();
        return CallHierarchy.getDefault().isIgnored(fullyQualifiedName);
    }

    private IType getTypeOfElement(IMember element) {
        if (element.getElementType() == 7) {
            return (IType)element;
        }
        return element.getDeclaringType();
    }
}

