/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jdt.ui.jarpackager.JarWriter3;
import org.eclipse.swt.widgets.Shell;

public class JarWriter4
extends JarWriter3 {
    private final JarPackageData fJarPackage;

    public JarWriter4(JarPackageData jarPackage, Shell parent) throws CoreException {
        super(jarPackage, parent);
        this.fJarPackage = jarPackage;
    }

    public void addZipEntry(ZipEntry zipEntry, ZipFile zipFile, String path) throws IOException {
        if (this.fJarPackage.areDirectoryEntriesIncluded()) {
            this.addDirectories(path);
        }
        JarEntry newEntry = new JarEntry(path.replace(File.separatorChar, '/'));
        if (this.fJarPackage.isCompressed()) {
            newEntry.setMethod(8);
        } else {
            newEntry.setMethod(0);
            newEntry.setSize(zipEntry.getSize());
            newEntry.setCrc(zipEntry.getCrc());
        }
        long lastModified = System.currentTimeMillis();
        newEntry.setTime(lastModified);
        this.addEntry(newEntry, zipFile.getInputStream(zipEntry));
    }

    public void addZipEntryStream(ZipEntry zipEntry, InputStream is, String path) throws IOException {
        if (this.fJarPackage.areDirectoryEntriesIncluded()) {
            this.addDirectories(path);
        }
        JarEntry newEntry = new JarEntry(path.replace(File.separatorChar, '/'));
        if (this.fJarPackage.isCompressed()) {
            newEntry.setMethod(8);
        } else {
            newEntry.setMethod(0);
            newEntry.setSize(zipEntry.getSize());
            newEntry.setCrc(zipEntry.getCrc());
        }
        long lastModified = System.currentTimeMillis();
        newEntry.setTime(lastModified);
        this.addEntry(newEntry, is);
    }

    public void write(File file, IPath destinationPath) throws CoreException {
        try {
            this.addFile(file, destinationPath);
        }
        catch (IOException ex) {
            String message = null;
            Path path = new Path(file.getAbsolutePath());
            message = ex.getLocalizedMessage() != null ? Messages.format(JarPackagerMessages.JarWriter_writeProblemWithMessage, new Object[]{BasicElementLabels.getPathLabel((IPath)path, false), ex.getLocalizedMessage()}) : Messages.format(JarPackagerMessages.JarWriter_writeProblem, BasicElementLabels.getPathLabel((IPath)path, false));
            throw JarPackagerUtil.createCoreException(message, ex);
        }
    }

    private void addFile(File file, IPath path) throws IOException {
        if (this.fJarPackage.areDirectoryEntriesIncluded()) {
            this.addDirectories(path);
        }
        JarEntry newEntry = new JarEntry(path.toString().replace(File.separatorChar, '/'));
        if (this.fJarPackage.isCompressed()) {
            newEntry.setMethod(8);
        } else {
            newEntry.setMethod(0);
            JarPackagerUtil.calculateCrcAndSize(newEntry, new FileInputStream(file), new byte[4096]);
        }
        newEntry.setTime(file.lastModified());
        this.addEntry(newEntry, new FileInputStream(file));
    }
}

