/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.core;

import java.io.File;
import org.eclipse.chemclipse.chromatogram.msd.process.model.IChromatogramProcessEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.core.IBatchProcess;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.IBatchProcessJob;
import org.eclipse.chemclipse.chromatogram.msd.process.support.ProcessTypeSupport;
import org.eclipse.chemclipse.chromatogram.xxd.report.core.ChromatogramReports;
import org.eclipse.chemclipse.chromatogram.xxd.report.model.IChromatogramReportSupplierEntry;
import org.eclipse.chemclipse.chromatogram.xxd.report.processing.IChromatogramReportProcessingInfo;
import org.eclipse.chemclipse.converter.model.IChromatogramInputEntry;
import org.eclipse.chemclipse.converter.model.IChromatogramOutputEntry;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramExportConverterProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.converter.processing.chromatogram.IChromatogramMSDImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.core.runtime.IProgressMonitor;

public class BatchProcess
implements IBatchProcess {
    private Logger logger = Logger.getLogger(BatchProcess.class);
    private static final String DESCRIPTION = "Batch Processor";
    private ProcessTypeSupport processTypeSupport = new ProcessTypeSupport();

    @Override
    public IProcessingInfo execute(IBatchProcessJob batchProcessJob, IProgressMonitor monitor) {
        ProcessingInfo batchProcessingInfo = new ProcessingInfo();
        if (batchProcessJob == null) {
            batchProcessingInfo.addErrorMessage(DESCRIPTION, "The batch job was null.");
        } else {
            for (IChromatogramInputEntry chromatogramInput : batchProcessJob.getChromatogramInputEntries()) {
                File chromatogramInputFile = new File(chromatogramInput.getInputFile());
                try {
                    IChromatogramMSD chromatogram = this.loadChromatogram(chromatogramInputFile, (IProcessingInfo)batchProcessingInfo, monitor);
                    this.processChromatogram(chromatogram, batchProcessJob, (IProcessingInfo)batchProcessingInfo, monitor);
                    batchProcessingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, DESCRIPTION, "The file has been processed successfully: " + chromatogramInputFile));
                }
                catch (TypeCastException typeCastException) {
                    batchProcessingInfo.addErrorMessage(DESCRIPTION, "A failure occurred fetching the chromatogram: " + chromatogramInputFile);
                }
            }
        }
        return batchProcessingInfo;
    }

    private IChromatogramMSD loadChromatogram(File chromatogramInputFile, IProcessingInfo batchProcessingInfo, IProgressMonitor monitor) throws TypeCastException {
        IChromatogramMSDImportConverterProcessingInfo processingInfo = ChromatogramConverterMSD.convert((File)chromatogramInputFile, (IProgressMonitor)monitor);
        batchProcessingInfo.addMessages((IProcessingInfo)processingInfo);
        IChromatogramMSD chromatogram = processingInfo.getChromatogram();
        return chromatogram;
    }

    private void processChromatogram(IChromatogramMSD chromatogram, IBatchProcessJob batchProcessJob, IProcessingInfo batchProcessingInfo, IProgressMonitor monitor) {
        if (chromatogram != null) {
            this.processChromatogramEntry(chromatogram, batchProcessJob, batchProcessingInfo, monitor);
            this.writeChromatogramOutputEntries(chromatogram, batchProcessJob, batchProcessingInfo, monitor);
            this.processChromatogramReportEntries(chromatogram, batchProcessJob, batchProcessingInfo, monitor);
        } else {
            batchProcessingInfo.addErrorMessage(DESCRIPTION, "The chromatogram must be not null.");
        }
    }

    private void processChromatogramEntry(IChromatogramMSD chromatogram, IBatchProcessJob batchProcessJob, IProcessingInfo batchProcessingInfo, IProgressMonitor monitor) {
        for (IChromatogramProcessEntry processEntry : batchProcessJob.getChromatogramProcessEntries()) {
            IChromatogramSelectionMSD chromatogramSelection = this.getChromatogramSelection(chromatogram, monitor);
            if (chromatogramSelection == null) {
                batchProcessingInfo.addErrorMessage(DESCRIPTION, "The chromatogram selection must not be null.");
                continue;
            }
            IProcessingInfo processingInfo = this.processTypeSupport.applyProcessor(chromatogramSelection, processEntry, monitor);
            batchProcessingInfo.addMessages(processingInfo);
        }
    }

    private void writeChromatogramOutputEntries(IChromatogramMSD chromatogram, IBatchProcessJob batchProcessJob, IProcessingInfo batchProcessingInfo, IProgressMonitor monitor) {
        IChromatogramExportConverterProcessingInfo processingInfo = null;
        for (IChromatogramOutputEntry chromatogramOutput : batchProcessJob.getChromatogramOutputEntries()) {
            String outputFolder = chromatogramOutput.getOutputFolder();
            if (!outputFolder.endsWith(File.separator)) {
                outputFolder = String.valueOf(outputFolder) + File.separator;
            }
            File chromatogramOutputFile = new File(String.valueOf(outputFolder) + chromatogram.getName());
            processingInfo = ChromatogramConverterMSD.convert((File)chromatogramOutputFile, (IChromatogramMSD)chromatogram, (String)chromatogramOutput.getConverterId(), (IProgressMonitor)monitor);
            batchProcessingInfo.addMessages((IProcessingInfo)processingInfo);
        }
    }

    private void processChromatogramReportEntries(IChromatogramMSD chromatogram, IBatchProcessJob batchProcessJob, IProcessingInfo batchProcessingInfo, IProgressMonitor monitor) {
        IChromatogramReportProcessingInfo processingInfo = null;
        for (IChromatogramReportSupplierEntry chromatogramReport : batchProcessJob.getChromatogramReportEntries()) {
            boolean appendReport;
            String reportFolderOrFile = chromatogramReport.getReportFolderOrFile();
            File chromatogramReportFile = new File(reportFolderOrFile);
            if (chromatogramReportFile.isDirectory()) {
                appendReport = false;
                if (!reportFolderOrFile.endsWith(File.separator)) {
                    reportFolderOrFile = String.valueOf(reportFolderOrFile) + File.separator;
                }
                chromatogramReportFile = new File(String.valueOf(reportFolderOrFile) + chromatogram.getName());
            } else {
                appendReport = true;
            }
            processingInfo = ChromatogramReports.generate((File)chromatogramReportFile, (boolean)appendReport, (IChromatogram)chromatogram, (String)chromatogramReport.getReportSupplierId(), (IProgressMonitor)monitor);
            batchProcessingInfo.addMessages((IProcessingInfo)processingInfo);
        }
    }

    private IChromatogramSelectionMSD getChromatogramSelection(IChromatogramMSD chromatogram, IProgressMonitor monitor) {
        assert (chromatogram != null) : "The chromatogram must be not null.";
        ChromatogramSelectionMSD chromatogramSelection = null;
        try {
            chromatogramSelection = new ChromatogramSelectionMSD((IChromatogram)chromatogram);
        }
        catch (ChromatogramIsNullException e) {
            this.logger.warn((Object)e);
        }
        return chromatogramSelection;
    }
}

