/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.preferences;

import org.eclipse.chemclipse.swt.ui.Activator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class PreferenceSupplier {
    private static final String RGB_DELIMITER = ",";
    private static Color positionMarkerBackgroundColor;
    private static Color positionMarkerForegroundColor;
    private static Color chromatogramColor;
    private static Color massSpectrumColor;

    private PreferenceSupplier() {
    }

    public static boolean showChromatogramPositionMarkerBox() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("showChromatogramSelectionPositionBox");
    }

    public static Color getPositionMarkerBackgroundColor() throws NumberFormatException {
        Color color = PreferenceSupplier.getColor("positionMarkerBackgroundColor");
        if (!color.equals((Object)positionMarkerBackgroundColor)) {
            if (positionMarkerBackgroundColor != null) {
                positionMarkerBackgroundColor.dispose();
            }
            positionMarkerBackgroundColor = color;
        }
        return positionMarkerBackgroundColor;
    }

    public static Color getPositionMarkerForegroundColor() {
        Color color = PreferenceSupplier.getColor("positionMarkerForegroundColor");
        if (!color.equals((Object)positionMarkerForegroundColor)) {
            if (positionMarkerForegroundColor != null) {
                positionMarkerForegroundColor.dispose();
            }
            positionMarkerForegroundColor = color;
        }
        return positionMarkerForegroundColor;
    }

    public static boolean showSelectedPeakInEditor() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("showSelectedPeakInEditor");
    }

    public static boolean showScansOfSelectedPeak() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("showScansOfSelectedPeak");
    }

    public static int sizeOfPeakScanMarker() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getInt("sizeOfPeakScanMarker");
    }

    public static boolean showBackgroundInChromatogramEditor() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("showBackgroundInEditor");
    }

    public static boolean showChromatogramArea() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("showChromatogramArea");
    }

    public static int getScanDisplayNumberOfIons() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getInt("scanDisplayNumberOfIons");
    }

    public static boolean isUseModuloDisplayNumberOfIons() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("useModuloDisplayOfIons");
    }

    public static Color getChromatogramColor() {
        Color color = PreferenceSupplier.getColor("colorChromatogram");
        if (!color.equals((Object)chromatogramColor)) {
            if (chromatogramColor != null) {
                chromatogramColor.dispose();
            }
            chromatogramColor = color;
        }
        return chromatogramColor;
    }

    public static Color getMassSpectrumColor() {
        Color color = PreferenceSupplier.getColor("colorMassSpectrum");
        if (!color.equals((Object)massSpectrumColor)) {
            if (massSpectrumColor != null) {
                massSpectrumColor.dispose();
            }
            massSpectrumColor = color;
        }
        return massSpectrumColor;
    }

    public static String getColorSchemeOverlay() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getString("colorSchemeOverlay");
    }

    public static boolean autoAdjustEditorIntensityDisplay() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("autoAdjustEditorIntensityDisplay");
    }

    public static boolean showChromatogramHairlineDivider() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("drawChromatogramHairlineDivider");
    }

    public static boolean condenseCycleNumberScans() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("condenseCycleNumberScans");
    }

    public static boolean showRetentionIndexWithoutDecimals() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("showRetentionIndexWithoutDecimals");
    }

    public static boolean showAreaWithoutDecimals() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("showAreaWithoutDecimals");
    }

    public static boolean isMoveRetentionTimeOnPeakSelection() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("moveRetentionTimeOnPeakSelection");
    }

    public static boolean autoAdjustViewIntensityDisplay() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("autoAdjustViewIntensityDisplay");
    }

    public static boolean useAlternateWindowMoveDirection() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("useAlternateWindowMoveDirection");
    }

    public static boolean isShowMilliseconds() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("showAxisMilliseconds");
    }

    public static boolean isShowRelativeIntensity() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("showAxisRelativeIntensity");
    }

    public static String getPathMassSpectrumLibraries() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getString("pathMassSpectrumLibraries");
    }

    public static void setPathMassSpectrumLibraries(String pathMassSpectrumLibraries) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue("pathMassSpectrumLibraries", pathMassSpectrumLibraries);
    }

    private static Color getColor(String preference) throws NumberFormatException {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String colorValues = store.getString(preference);
        String[] rgbValues = colorValues.split(RGB_DELIMITER);
        int red = Integer.valueOf(rgbValues[0].trim());
        int green = Integer.valueOf(rgbValues[1].trim());
        int blue = Integer.valueOf(rgbValues[2].trim());
        RGB rgb = new RGB(red, green, blue);
        return new Color((Device)Display.getCurrent(), rgb);
    }
}

