/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.peak;

import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.PeakIntegrationEntriesContentProvider;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.PeakIntegrationEntriesLabelProvider;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.PeakIntegrationEntriesTableComparator;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PeakIntegrationEntriesUI {
    private ExtendedTableViewer tableViewer;
    private PeakIntegrationEntriesTableComparator peakIntegrationEntriesTableComparator;
    private String[] titles = new String[]{"Ion (0 = TIC)", "Area"};
    private int[] bounds = new int[]{100, 100};

    public PeakIntegrationEntriesUI(Composite parent, int style) {
        parent.setLayout((Layout)new FillLayout());
        this.tableViewer = new ExtendedTableViewer(parent, 66306);
        this.tableViewer.createColumns(this.titles, this.bounds);
        this.tableViewer.setContentProvider((IContentProvider)new PeakIntegrationEntriesContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PeakIntegrationEntriesLabelProvider());
        this.peakIntegrationEntriesTableComparator = new PeakIntegrationEntriesTableComparator();
        this.tableViewer.setComparator((ViewerComparator)this.peakIntegrationEntriesTableComparator);
        this.tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    PeakIntegrationEntriesUI.this.tableViewer.copyToClipboard(PeakIntegrationEntriesUI.this.titles);
                }
            }
        });
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void update(IPeakMSD peak, boolean forceReload) {
        if (peak != null) {
            this.tableViewer.setInput((Object)peak);
        }
    }

    public void clear() {
        this.tableViewer.setInput(null);
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }
}

