/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.logging.support;

import java.io.File;
import java.util.Properties;
import org.eclipse.chemclipse.logging.Activator;
import org.osgi.framework.Version;

public class Settings {
    public static final String D_APPLICATION_NAME = "application.name";
    public static final String D_APPLICATION_VERSION = "application.version";
    private static final String DEFAULT_APPLICATION_NAME = "Chromatography_Application";
    private static final String DEFAULT_APPLICATION_VERSION = "0.7.x";
    private static final String D_OSGI_INSTANCE_AREA = "osgi.instance.area";
    private static final String D_OSGI_USER_AREA = "osgi.user.area";
    private static File fileSettingsFolder = null;
    private static File fileWorkspaceFolder = null;

    private Settings() {
    }

    public static final File getSettingsDirectory() {
        if (Settings.isRunInitialization()) {
            Settings.initialize();
        }
        return fileSettingsFolder;
    }

    public static final File getWorkspaceDirectory() {
        if (Settings.isRunInitialization()) {
            Settings.initialize();
        }
        return fileWorkspaceFolder;
    }

    public static final String getVersionIdentifier() {
        String applicationVersion;
        Properties properties = System.getProperties();
        Object name = properties.get(D_APPLICATION_VERSION);
        if (name != null && name instanceof String) {
            applicationVersion = (String)name;
        } else {
            applicationVersion = DEFAULT_APPLICATION_VERSION;
            try {
                Version version = Activator.getContext().getBundle().getVersion();
                StringBuilder builder = new StringBuilder();
                builder.append(version.getMajor());
                builder.append(".");
                builder.append(version.getMinor());
                builder.append(".");
                builder.append("x");
                applicationVersion = builder.toString();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return applicationVersion;
    }

    public static final String getDirectory(String folder) {
        StringBuilder builder = new StringBuilder();
        builder.append(System.getProperty("user.home"));
        builder.append(File.separator);
        builder.append(folder);
        builder.append(File.separator);
        builder.append(Settings.getVersionIdentifier());
        return builder.toString();
    }

    public static final String getApplicationName() {
        Properties properties = System.getProperties();
        Object name = properties.get(D_APPLICATION_NAME);
        String applicationName = name != null && name instanceof String ? (String)name : DEFAULT_APPLICATION_NAME;
        if (!applicationName.equals("")) {
            applicationName = applicationName.replaceAll("-", "");
            applicationName = applicationName.replaceAll("\\.", "");
            applicationName = applicationName.replaceAll(":", "");
            applicationName = applicationName.replaceAll(" ", "");
            applicationName = applicationName.replaceAll("_", "");
        }
        return applicationName;
    }

    private static boolean isRunInitialization() {
        return fileSettingsFolder == null || fileWorkspaceFolder == null;
    }

    private static void initialize() {
        Object settingsFolder;
        Properties properties = System.getProperties();
        Object workspaceFolder = properties.get(D_OSGI_INSTANCE_AREA);
        if (Settings.isSetDefaults(workspaceFolder, settingsFolder = properties.get(D_OSGI_USER_AREA))) {
            String applicationName;
            String applicationWorkspaceFolder = applicationName = Settings.getApplicationName();
            String applicationSettingsFolder = "." + applicationName.toLowerCase();
            fileWorkspaceFolder = new File(Settings.getDirectory(applicationWorkspaceFolder));
            fileSettingsFolder = new File(Settings.getDirectory(applicationSettingsFolder));
        } else {
            String applicationWorkspaceFolder = (String)workspaceFolder;
            applicationWorkspaceFolder = applicationWorkspaceFolder.replace("file:", "");
            String applicationSettingsFolder = (String)settingsFolder;
            applicationSettingsFolder = applicationSettingsFolder.replace("file:", "");
            fileWorkspaceFolder = new File(applicationWorkspaceFolder);
            fileSettingsFolder = new File(applicationSettingsFolder);
        }
        System.out.println("-----------------------------------------");
        System.out.println("Product Initializiation: " + Settings.class.getName());
        System.out.println("Workspace Path: " + fileWorkspaceFolder);
        System.out.println("Settings Path: " + fileSettingsFolder);
        System.out.println("-----------------------------------------");
    }

    private static boolean isSetDefaults(Object workspaceFolder, Object settingsFolder) {
        if (workspaceFolder == null || settingsFolder == null) {
            return true;
        }
        if (!(workspaceFolder instanceof String) || !(settingsFolder instanceof String)) {
            return true;
        }
        String workspace = (String)workspaceFolder;
        String settings = (String)settingsFolder;
        if (workspace.equals("") || settings.equals("")) {
            return true;
        }
        String regex = ".*runtime.*product/";
        return workspace.matches(regex) || settings.matches(regex);
    }
}

