/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.logging.ui.views;

import java.io.File;
import javax.inject.Inject;
import org.eclipse.chemclipse.logging.support.PropertiesUtil;
import org.eclipse.chemclipse.logging.ui.internal.support.LogFileContentProvider;
import org.eclipse.chemclipse.logging.ui.internal.support.LogFileLabelProvider;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MInputPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class LogFileView {
    @Inject
    private EPartService partService;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;
    private TableViewer tableViewer;

    @Inject
    public LogFileView(Composite parent) {
        this.tableViewer = new TableViewer(parent, 66306);
        this.tableViewer.setContentProvider((IContentProvider)new LogFileContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LogFileLabelProvider());
        this.tableViewer.setInput((Object)new File(PropertiesUtil.getLogFilePath()));
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object data = LogFileView.this.getSelectedObject();
                if (data != null && data instanceof File) {
                    File file = (File)data;
                    MPartStack partStack = (MPartStack)LogFileView.this.modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)LogFileView.this.application);
                    MInputPart part = MBasicFactory.INSTANCE.createInputPart();
                    part.setElementId("org.eclipse.chemclipse.logging.ui.part.logfileEditor");
                    part.setContributionURI("bundleclass://org.eclipse.chemclipse.logging.ui/org.eclipse.chemclipse.logging.ui.editors.LogFileEditor");
                    part.setObject((Object)file.getAbsolutePath());
                    part.setIconURI("platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/log.gif");
                    part.setLabel(file.getName());
                    part.setTooltip("Log File Editor");
                    part.setCloseable(true);
                    partStack.getChildren().add(part);
                    LogFileView.this.partService.showPart((MPart)part, EPartService.PartState.ACTIVATE);
                }
            }
        });
        this.tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    Object[] elements = LogFileView.this.getSelectedObjects();
                    LogFileView.this.deleteLogFiles(elements);
                }
            }
        });
    }

    @Focus
    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    private void deleteLogFiles(Object[] elements) {
        if (elements != null && elements.length > 0) {
            MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 456);
            messageBox.setText("Delete Log File(s)?");
            messageBox.setMessage("Do you really want to delete the selected log file(s)?");
            if (messageBox.open() == 64) {
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof File) {
                        File file = (File)element;
                        file.delete();
                        this.tableViewer.remove(element);
                    }
                    ++n2;
                }
            }
        }
    }

    private Object getSelectedObject() {
        Object data = null;
        Object[] items = this.getSelectedObjects();
        if (items != null) {
            data = items[0];
        }
        return data;
    }

    private Object[] getSelectedObjects() {
        Object[] data = null;
        Table table = this.tableViewer.getTable();
        TableItem[] selectedItems = table.getSelection();
        int items = selectedItems.length;
        if (items > 0) {
            data = new Object[items];
            int item = 0;
            while (item < items) {
                data[item] = selectedItems[item].getData();
                ++item;
            }
        }
        return data;
    }
}

