/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.swt.ui.internal.provider;

import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakModelCSD;
import org.eclipse.chemclipse.support.ui.swt.AbstractRecordTableComparator;
import org.eclipse.chemclipse.support.ui.swt.IRecordTableComparator;
import org.eclipse.jface.viewers.Viewer;

public class PeakListTableComparator
extends AbstractRecordTableComparator
implements IRecordTableComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        int sortOrder = 0;
        if (e1 instanceof IPeakCSD && e2 instanceof IPeakCSD) {
            IPeakCSD peak1 = (IPeakCSD)e1;
            IPeakModelCSD peakModel1 = peak1.getPeakModel();
            IPeakCSD peak2 = (IPeakCSD)e2;
            IPeakModelCSD peakModel2 = peak2.getPeakModel();
            switch (this.getPropertyIndex()) {
                case 0: {
                    sortOrder = peakModel2.getRetentionTimeAtPeakMaximum() - peakModel1.getRetentionTimeAtPeakMaximum();
                    break;
                }
                case 1: {
                    sortOrder = Float.compare(peakModel2.getPeakMaximum().getRetentionIndex(), peakModel1.getPeakMaximum().getRetentionIndex());
                    break;
                }
                case 2: {
                    sortOrder = Double.compare(peak2.getIntegratedArea(), peak1.getIntegratedArea());
                    break;
                }
                case 3: {
                    sortOrder = peakModel2.getStartRetentionTime() - peakModel1.getStartRetentionTime();
                    break;
                }
                case 4: {
                    sortOrder = peakModel2.getStopRetentionTime() - peakModel1.getStopRetentionTime();
                    break;
                }
                case 5: {
                    sortOrder = peakModel2.getWidthByInflectionPoints() - peakModel1.getWidthByInflectionPoints();
                    break;
                }
                case 6: 
                case 7: {
                    if (!(e1 instanceof IChromatogramPeakCSD) || !(e2 instanceof IChromatogramPeakCSD)) break;
                    IChromatogramPeakCSD chromatogramPeak1 = (IChromatogramPeakCSD)e1;
                    IChromatogramPeakCSD chromatogramPeak2 = (IChromatogramPeakCSD)e2;
                    switch (this.getPropertyIndex()) {
                        case 6: {
                            sortOrder = chromatogramPeak2.getScanMax() - chromatogramPeak1.getScanMax();
                            break;
                        }
                        case 7: {
                            sortOrder = Float.compare(chromatogramPeak2.getSignalToNoiseRatio(), chromatogramPeak1.getSignalToNoiseRatio());
                        }
                    }
                    break;
                }
                case 8: {
                    sortOrder = Float.compare(peakModel2.getLeading(), peakModel1.getLeading());
                    break;
                }
                case 9: {
                    sortOrder = Float.compare(peakModel2.getTailing(), peakModel1.getTailing());
                    break;
                }
                case 10: {
                    sortOrder = peak2.getModelDescription().compareTo(peak1.getModelDescription());
                    break;
                }
                case 11: {
                    sortOrder = peak2.getSuggestedNumberOfComponents() - peak1.getSuggestedNumberOfComponents();
                    break;
                }
                default: {
                    sortOrder = 0;
                }
            }
        }
        if (this.getDirection() == 0) {
            sortOrder = -sortOrder;
        }
        return sortOrder;
    }
}

