/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.implementation.PeakIntensityValues;
import org.eclipse.chemclipse.model.implementation.Peaks;
import org.eclipse.chemclipse.msd.converter.io.IPeakReader;
import org.eclipse.chemclipse.msd.converter.processing.peak.IPeakImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.processing.peak.PeakImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.model.core.IPeakIon;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.PeakIon;
import org.eclipse.chemclipse.msd.model.implementation.PeakMSD;
import org.eclipse.chemclipse.msd.model.implementation.PeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.implementation.PeakModelMSD;
import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.core.runtime.IProgressMonitor;

public class AmdisELUReader
implements IPeakReader {
    private static final Logger logger = Logger.getLogger(AmdisELUReader.class);
    private static final Pattern hitsPattern = Pattern.compile("(NAME)");
    private static final Pattern peakDataPattern = Pattern.compile("(NAME)(.*?)(^$)", 40);
    private static final Pattern namePattern = Pattern.compile("(NAME)(.*)(SC)([0-9]+)(.*)(FR)([0-9]+)(-)([0-9]+)(.*)(RT)([0-9]+[.,]+[0-9]+)");
    private static final Pattern profileDataPattern = Pattern.compile("(RE)(.*?)(NUM PEAKS)", 40);
    private static final Pattern profilePattern = Pattern.compile("([0-9]+)");
    private static final Pattern peakPattern = Pattern.compile("(NUM PEAKS)(.*)", 40);
    private static final Pattern ionPattern = Pattern.compile("\\((\\d+),(\\d+) ?(\\w[\\d.]*)?\\)");
    private static final String NEW_LINE = "\n";
    private static final String CARRIAGE_RETURN = "\r";

    public IPeakImportConverterProcessingInfo read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        PeakImportConverterProcessingInfo processingInfo = new PeakImportConverterProcessingInfo();
        String content = FileUtils.readFileToString((File)file);
        int numberOfHits = this.getNumberOfHits(content);
        if (numberOfHits <= 0) {
            processingInfo.addErrorMessage("AMDIS ELU Parser", "There seems to be no peak in the file.");
        } else {
            int scanInterval = numberOfHits <= 2 ? this.calculateScanIntervalSimple(content) : this.calculateScanIntervalExtended(content);
            this.extractAmdisPeaks(content, scanInterval, (IPeakImportConverterProcessingInfo)processingInfo);
        }
        return processingInfo;
    }

    private int getNumberOfHits(String content) {
        Matcher matcher = hitsPattern.matcher(content);
        int counter = 0;
        while (matcher.find()) {
            ++counter;
        }
        return counter;
    }

    private int calculateScanIntervalSimple(String content) {
        ArrayList<Double> scanIntervals = new ArrayList<Double>();
        Matcher matcher = namePattern.matcher(content);
        while (matcher.find()) {
            try {
                int scan = Integer.parseInt(matcher.group(4));
                double retentionTime = Double.parseDouble(matcher.group(12)) * 60000.0;
                if (scan <= 0) continue;
                scanIntervals.add(retentionTime / (double)scan);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int size = scanIntervals.size();
        double[] values = new double[size];
        int index = 0;
        while (index < size) {
            values[index] = (Double)scanIntervals.get(index);
            ++index;
        }
        int scanInterval = (int)Calculations.getMean((double[])values);
        return scanInterval;
    }

    private int calculateScanIntervalExtended(String content) {
        HashMap<Integer, Double> scanRetentionTimes = new HashMap<Integer, Double>();
        Matcher matcher = namePattern.matcher(content);
        while (matcher.find()) {
            try {
                int scan = Integer.parseInt(matcher.group(4));
                double retentionTime = Double.parseDouble(matcher.group(12)) * 60000.0;
                if (scan <= 0) continue;
                scanRetentionTimes.put(scan, retentionTime);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        ArrayList scans = new ArrayList(scanRetentionTimes.keySet());
        Collections.sort(scans);
        int scanIndexFirst = 0;
        int end = scans.size();
        int start = end / 2;
        ArrayList<Double> scanIntervals = new ArrayList<Double>();
        int scanIndexNext = start;
        while (scanIndexNext < end) {
            int firstScan = (Integer)scans.get(scanIndexFirst++);
            int nextScan = (Integer)scans.get(scanIndexNext);
            double firstRetentionTime = (Double)scanRetentionTimes.get(firstScan);
            double nextRetentionTime = (Double)scanRetentionTimes.get(nextScan);
            int deltaScan = nextScan - firstScan;
            double deltaRetentionTime = nextRetentionTime - firstRetentionTime;
            if (deltaScan > 0) {
                double scanInterval = deltaRetentionTime / (double)deltaScan;
                scanIntervals.add(scanInterval);
            }
            ++scanIndexNext;
        }
        int size = scanIntervals.size();
        double[] values = new double[size];
        int index = 0;
        while (index < size) {
            values[index] = (Double)scanIntervals.get(index);
            ++index;
        }
        int scanInterval = (int)Calculations.getMean((double[])values);
        return scanInterval;
    }

    private void extractAmdisPeaks(String content, int scanInterval, IPeakImportConverterProcessingInfo processingInfo) {
        if (scanInterval <= 0) {
            processingInfo.addErrorMessage("AMDIS ELU Parser", "There seems to be no peak in the file. The scan interval is <= 0.");
        } else {
            Peaks peaks = new Peaks();
            Matcher matcher = peakDataPattern.matcher(content);
            while (matcher.find()) {
                String peakData = matcher.group();
                IPeakMSD peak = this.extractAmdisPeak(peakData, scanInterval);
                if (peak == null) continue;
                peaks.addPeak((IPeak)peak);
            }
            processingInfo.setPeaks((IPeaks)peaks);
        }
    }

    private IPeakMSD extractAmdisPeak(String peakData, int scanInterval) {
        PeakMSD peak = null;
        int peakStartRetentionTime = this.extractPeakStartRetentionTime(peakData, scanInterval);
        if (peakStartRetentionTime > 0) {
            IPeakIntensityValues peakIntensityValues = this.extractPeakProfile(peakData, peakStartRetentionTime, scanInterval);
            float totalSignal = this.extractTotalSignal(peakIntensityValues);
            peakIntensityValues.normalize();
            IPeakMassSpectrum peakMassSpectrum = this.extractPeakMassSpectrum(peakData);
            peakMassSpectrum.adjustTotalSignal(totalSignal);
            try {
                PeakModelMSD peakModel = new PeakModelMSD(peakMassSpectrum, peakIntensityValues, 0.0f, 0.0f);
                this.extractScanRange((IPeakModelMSD)peakModel, peakData);
                peak = new PeakMSD((IPeakModelMSD)peakModel, "AMDIS ELU");
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)e);
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
        }
        return peak;
    }

    private float extractTotalSignal(IPeakIntensityValues peakIntensityValues) {
        float totalSignal = Float.MIN_VALUE;
        Iterator iterator = peakIntensityValues.getRetentionTimes().iterator();
        while (iterator.hasNext()) {
            int retentionTime = (Integer)iterator.next();
            float signal = ((Float)peakIntensityValues.getIntensityValue(retentionTime).getValue()).floatValue();
            if (!(signal > totalSignal)) continue;
            totalSignal = signal;
        }
        return totalSignal;
    }

    private int extractPeakStartRetentionTime(String peakData, int scanInterval) {
        int startRetentionTime = 0;
        Matcher matcher = namePattern.matcher(peakData);
        if (matcher.find()) {
            try {
                int scan = Integer.parseInt(matcher.group(4));
                int startScan = Integer.parseInt(matcher.group(7));
                double retentionTime = (int)(Double.parseDouble(matcher.group(12)) * 60000.0);
                startRetentionTime = (int)(retentionTime - (double)((scan - startScan - 1) * scanInterval));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return startRetentionTime;
    }

    private void extractScanRange(IPeakModelMSD peakModel, String peakData) {
        Matcher matcher = namePattern.matcher(peakData);
        if (matcher.find()) {
            int maxScan = Integer.parseInt(matcher.group(4));
            int startScan = Integer.parseInt(matcher.group(7));
            int stopScan = Integer.parseInt(matcher.group(9));
            peakModel.setTemporarilyInfo("START_SCAN", (Object)startScan);
            peakModel.setTemporarilyInfo("STOP_SCAN", (Object)stopScan);
            peakModel.setTemporarilyInfo("MAX_SCAN", (Object)maxScan);
        }
    }

    private IPeakIntensityValues extractPeakProfile(String peakData, int peakStartRetentionTime, int scanInterval) {
        PeakIntensityValues peakIntensityValues = new PeakIntensityValues(Float.MAX_VALUE);
        Matcher matcher = profileDataPattern.matcher(peakData);
        if (matcher.find()) {
            String profileData = matcher.group().replaceAll(NEW_LINE, " ").replaceAll(CARRIAGE_RETURN, " ");
            this.extractProfile((IPeakIntensityValues)peakIntensityValues, profileData, peakStartRetentionTime, scanInterval);
        }
        return peakIntensityValues;
    }

    private void extractProfile(IPeakIntensityValues peakIntensityValues, String profileData, int peakStartRetentionTime, int scanInterval) {
        int retentionTime = peakStartRetentionTime;
        Matcher matcher = profilePattern.matcher(profileData);
        while (matcher.find()) {
            try {
                float relativeIntensity = Float.parseFloat(matcher.group(1));
                peakIntensityValues.addIntensityValue(retentionTime, relativeIntensity);
            }
            catch (NumberFormatException numberFormatException) {}
            retentionTime += scanInterval;
        }
    }

    private IPeakMassSpectrum extractPeakMassSpectrum(String peakData) {
        PeakMassSpectrum peakMassSpectrum = new PeakMassSpectrum();
        Matcher matcher = peakPattern.matcher(peakData);
        if (matcher.find()) {
            String massSpectrumData = matcher.group().replaceAll(NEW_LINE, " ").replaceAll(CARRIAGE_RETURN, " ");
            this.extractPeakIons(massSpectrumData, (IPeakMassSpectrum)peakMassSpectrum);
        }
        return peakMassSpectrum;
    }

    private void extractPeakIons(String massSpectrumData, IPeakMassSpectrum peakMassSpectrum) {
        Matcher ions = ionPattern.matcher(massSpectrumData);
        while (ions.find()) {
            try {
                if (PreferenceSupplier.isExcludeUncertainIons()) {
                    if (ions.group(3) != null) continue;
                    peakMassSpectrum.addIon(this.getPeakIonFromRegex(ions));
                    continue;
                }
                peakMassSpectrum.addIon(this.getPeakIonFromRegex(ions));
            }
            catch (NumberFormatException e) {
                logger.warn((Object)e);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
    }

    private IPeakIon getPeakIonFromRegex(Matcher ions) throws AbundanceLimitExceededException, IonLimitExceededException {
        double ion = Double.parseDouble(ions.group(1));
        float abundance = Float.parseFloat(ions.group(2));
        PeakIon peakIon = new PeakIon(ion, abundance);
        return peakIon;
    }
}

