/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.lu;

import org.ejml.alg.dense.decomposition.lu.LUDecompositionBase_D64;
import org.ejml.alg.dense.linsol.lu.LinearSolverLuBase_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.SpecializedOps;

public class LinearSolverLuKJI_D64
extends LinearSolverLuBase_D64 {
    private double[] dataLU;
    private int[] pivot;

    public LinearSolverLuKJI_D64(LUDecompositionBase_D64 decomp) {
        super(decomp);
    }

    @Override
    public boolean setA(DenseMatrix64F A) {
        boolean ret = super.setA(A);
        this.pivot = this.decomp.getPivot();
        this.dataLU = this.decomp.getLU().data;
        return ret;
    }

    @Override
    public void solve(DenseMatrix64F b, DenseMatrix64F x) {
        int j;
        int i;
        if (b.numCols != x.numCols || b.numRows != this.numRows || x.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected matrix size");
        }
        if (b == x) {
            throw new IllegalArgumentException("Current doesn't support using the same matrix instance");
        }
        SpecializedOps.copyChangeRow(this.pivot, b, x);
        int nx = b.numCols;
        double[] dataX = x.data;
        int k = 0;
        while (k < this.numCols) {
            i = k + 1;
            while (i < this.numCols) {
                j = 0;
                while (j < nx) {
                    int n = i * nx + j;
                    dataX[n] = dataX[n] - dataX[k * nx + j] * this.dataLU[i * this.numCols + k];
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        k = this.numCols - 1;
        while (k >= 0) {
            int j2 = 0;
            while (j2 < nx) {
                int n = k * nx + j2;
                dataX[n] = dataX[n] / this.dataLU[k * this.numCols + k];
                ++j2;
            }
            i = 0;
            while (i < k) {
                j = 0;
                while (j < nx) {
                    int n = i * nx + j;
                    dataX[n] = dataX[n] - dataX[k * nx + j] * this.dataLU[i * this.numCols + k];
                    ++j;
                }
                ++i;
            }
            --k;
        }
    }
}

