/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import org.ejml.data.Complex64F;
import org.ejml.data.ComplexMatrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RealMatrix32F;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.ReshapeMatrix;
import org.ejml.ops.ReadMatrixCsv;

public class MatrixIO {
    public static void saveBin(RealMatrix64F A, String fileName) throws IOException {
        FileOutputStream fileStream = new FileOutputStream(fileName);
        ObjectOutputStream stream = new ObjectOutputStream(fileStream);
        try {
            stream.writeObject(A);
            stream.flush();
        }
        finally {
            try {
                stream.close();
            }
            finally {
                fileStream.close();
            }
        }
    }

    public static <T extends RealMatrix64F> T loadBin(String fileName) throws IOException {
        RealMatrix64F ret;
        FileInputStream fileStream = new FileInputStream(fileName);
        ObjectInputStream stream = new ObjectInputStream(fileStream);
        try {
            ret = (RealMatrix64F)stream.readObject();
            if (stream.available() != 0) {
                throw new RuntimeException("File not completely read?");
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        stream.close();
        return (T)ret;
    }

    public static void saveCSV(RealMatrix64F A, String fileName) throws IOException {
        PrintStream fileStream = new PrintStream(fileName);
        fileStream.println(String.valueOf(A.getNumRows()) + " " + A.getNumCols() + " real");
        int i = 0;
        while (i < A.getNumRows()) {
            int j = 0;
            while (j < A.getNumCols()) {
                fileStream.print(String.valueOf(A.get(i, j)) + " ");
                ++j;
            }
            fileStream.println();
            ++i;
        }
        fileStream.close();
    }

    public static DenseMatrix64F loadCSV(String fileName) throws IOException {
        FileInputStream fileStream = new FileInputStream(fileName);
        ReadMatrixCsv csv = new ReadMatrixCsv(fileStream);
        DenseMatrix64F ret = (DenseMatrix64F)csv.read();
        fileStream.close();
        return ret;
    }

    public static DenseMatrix64F loadCSV(String fileName, int numRows, int numCols) throws IOException {
        FileInputStream fileStream = new FileInputStream(fileName);
        ReadMatrixCsv csv = new ReadMatrixCsv(fileStream);
        DenseMatrix64F ret = csv.readReal(numRows, numCols);
        fileStream.close();
        return ret;
    }

    public static void print(PrintStream out, RealMatrix64F mat) {
        MatrixIO.print(out, mat, 6, 3);
    }

    public static void print(PrintStream out, RealMatrix64F mat, int numChar, int precision) {
        String format = "%" + numChar + "." + precision + "f ";
        MatrixIO.print(out, mat, format);
    }

    public static void print(PrintStream out, RealMatrix64F mat, String format) {
        String type = ReshapeMatrix.class.isAssignableFrom(mat.getClass()) ? "dense" : "dense fixed";
        out.println("Type = " + type + " real , numRows = " + mat.getNumRows() + " , numCols = " + mat.getNumCols());
        format = String.valueOf(format) + " ";
        int y = 0;
        while (y < mat.getNumRows()) {
            int x = 0;
            while (x < mat.getNumCols()) {
                out.printf(format, mat.get(y, x));
                ++x;
            }
            out.println();
            ++y;
        }
    }

    public static void print(PrintStream out, RealMatrix32F mat) {
        MatrixIO.print(out, mat, 6, 3);
    }

    public static void print(PrintStream out, RealMatrix32F mat, int numChar, int precision) {
        String format = "%" + numChar + "." + precision + "f ";
        MatrixIO.print(out, mat, format);
    }

    public static void print(PrintStream out, RealMatrix32F mat, String format) {
        String type = ReshapeMatrix.class.isAssignableFrom(mat.getClass()) ? "dense" : "dense fixed";
        out.println("Type = " + type + " , numRows = " + mat.getNumRows() + " , numCols = " + mat.getNumCols());
        format = String.valueOf(format) + " ";
        int y = 0;
        while (y < mat.getNumRows()) {
            int x = 0;
            while (x < mat.getNumCols()) {
                out.printf(format, Float.valueOf(mat.get(y, x)));
                ++x;
            }
            out.println();
            ++y;
        }
    }

    public static void print(PrintStream out, RealMatrix64F mat, String format, int row0, int row1, int col0, int col1) {
        out.println("Type = submatrix , rows " + row0 + " to " + row1 + "  columns " + col0 + " to " + col1);
        format = String.valueOf(format) + " ";
        int y = row0;
        while (y < row1) {
            int x = col0;
            while (x < col1) {
                out.printf(format, mat.get(y, x));
                ++x;
            }
            out.println();
            ++y;
        }
    }

    public static void print(PrintStream out, ComplexMatrix64F mat) {
        MatrixIO.print(out, mat, 6, 3);
    }

    public static void print(PrintStream out, ComplexMatrix64F mat, int numChar, int precision) {
        String format = "%" + numChar + "." + precision + "f + %" + numChar + "." + precision + "fi";
        MatrixIO.print(out, mat, format);
    }

    public static void print(PrintStream out, ComplexMatrix64F mat, String format) {
        String type = "dense";
        out.println("Type = " + type + " complex , numRows = " + mat.getNumRows() + " , numCols = " + mat.getNumCols());
        format = String.valueOf(format) + " ";
        Complex64F c = new Complex64F();
        int y = 0;
        while (y < mat.getNumRows()) {
            int x = 0;
            while (x < mat.getNumCols()) {
                mat.get(y, x, c);
                out.printf(format, c.real, c.imaginary);
                if (x < mat.getNumCols() - 1) {
                    out.print(" , ");
                }
                ++x;
            }
            out.println();
            ++y;
        }
    }
}

