/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.UtilEjml;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SpecializedOps;

public class SingularOps {
    public static void descendingOrder(DenseMatrix64F U, boolean tranU, DenseMatrix64F W, DenseMatrix64F V, boolean tranV) {
        int numSingular = Math.min(W.numRows, W.numCols);
        SingularOps.checkSvdMatrixSize(U, tranU, W, V, tranV);
        int i = 0;
        while (i < numSingular) {
            double bigValue = -1.0;
            int bigIndex = -1;
            int j = i;
            while (j < numSingular) {
                double v = W.get(j, j);
                if (v > bigValue) {
                    bigValue = v;
                    bigIndex = j;
                }
                ++j;
            }
            if (bigIndex != i) {
                if (bigIndex == -1) break;
                double tmp = W.get(i, i);
                W.set(i, i, bigValue);
                W.set(bigIndex, bigIndex, tmp);
                if (V != null) {
                    SingularOps.swapRowOrCol(V, tranV, i, bigIndex);
                }
                if (U != null) {
                    SingularOps.swapRowOrCol(U, tranU, i, bigIndex);
                }
            }
            ++i;
        }
    }

    public static void descendingOrder(DenseMatrix64F U, boolean tranU, double[] singularValues, int numSingularValues, DenseMatrix64F V, boolean tranV) {
        int i = 0;
        while (i < numSingularValues) {
            double bigValue = -1.0;
            int bigIndex = -1;
            int j = i;
            while (j < numSingularValues) {
                double v = singularValues[j];
                if (v > bigValue) {
                    bigValue = v;
                    bigIndex = j;
                }
                ++j;
            }
            if (bigIndex != i) {
                if (bigIndex == -1) break;
                double tmp = singularValues[i];
                singularValues[i] = bigValue;
                singularValues[bigIndex] = tmp;
                if (V != null) {
                    SingularOps.swapRowOrCol(V, tranV, i, bigIndex);
                }
                if (U != null) {
                    SingularOps.swapRowOrCol(U, tranU, i, bigIndex);
                }
            }
            ++i;
        }
    }

    public static void checkSvdMatrixSize(DenseMatrix64F U, boolean tranU, DenseMatrix64F W, DenseMatrix64F V, boolean tranV) {
        boolean compact;
        int numSingular = Math.min(W.numRows, W.numCols);
        boolean bl = compact = W.numRows == W.numCols;
        if (compact) {
            if (U != null) {
                if (tranU && U.numRows != numSingular) {
                    throw new IllegalArgumentException("Unexpected size of matrix U");
                }
                if (!tranU && U.numCols != numSingular) {
                    throw new IllegalArgumentException("Unexpected size of matrix U");
                }
            }
            if (V != null) {
                if (tranV && V.numRows != numSingular) {
                    throw new IllegalArgumentException("Unexpected size of matrix V");
                }
                if (!tranV && V.numCols != numSingular) {
                    throw new IllegalArgumentException("Unexpected size of matrix V");
                }
            }
        } else {
            if (U != null && U.numRows != U.numCols) {
                throw new IllegalArgumentException("Unexpected size of matrix U");
            }
            if (V != null && V.numRows != V.numCols) {
                throw new IllegalArgumentException("Unexpected size of matrix V");
            }
            if (U != null && U.numRows != W.numRows) {
                throw new IllegalArgumentException("Unexpected size of W");
            }
            if (V != null && V.numRows != W.numCols) {
                throw new IllegalArgumentException("Unexpected size of W");
            }
        }
    }

    private static void swapRowOrCol(DenseMatrix64F M, boolean tran, int i, int bigIndex) {
        if (tran) {
            int col = 0;
            while (col < M.numCols) {
                double tmp = M.get(i, col);
                M.set(i, col, M.get(bigIndex, col));
                M.set(bigIndex, col, tmp);
                ++col;
            }
        } else {
            int row = 0;
            while (row < M.numRows) {
                double tmp = M.get(row, i);
                M.set(row, i, M.get(row, bigIndex));
                M.set(row, bigIndex, tmp);
                ++row;
            }
        }
    }

    public static DenseMatrix64F nullSpace(SingularValueDecomposition<DenseMatrix64F> svd, DenseMatrix64F nullSpace, double tol) {
        int N = svd.numberOfSingularValues();
        double[] s = svd.getSingularValues();
        DenseMatrix64F V = svd.getV(null, true);
        if (V.numRows != svd.numCols()) {
            throw new IllegalArgumentException("Can't compute the null space using a compact SVD for a matrix of this size.");
        }
        int numVectors = svd.numCols() - N;
        int i = 0;
        while (i < N) {
            if (s[i] <= tol) {
                ++numVectors;
            }
            ++i;
        }
        if (nullSpace == null) {
            nullSpace = new DenseMatrix64F(numVectors, svd.numCols());
        } else {
            nullSpace.reshape(numVectors, svd.numCols());
        }
        int count = 0;
        int i2 = 0;
        while (i2 < N) {
            if (s[i2] <= tol) {
                CommonOps.extract(V, i2, i2 + 1, 0, V.numCols, nullSpace, count++, 0);
            }
            ++i2;
        }
        i2 = N;
        while (i2 < svd.numCols()) {
            CommonOps.extract(V, i2, i2 + 1, 0, V.numCols, nullSpace, count++, 0);
            ++i2;
        }
        CommonOps.transpose(nullSpace);
        return nullSpace;
    }

    public static DenseMatrix64F nullVector(SingularValueDecomposition<DenseMatrix64F> svd, boolean isRight, DenseMatrix64F nullVector) {
        DenseMatrix64F A;
        int N = svd.numberOfSingularValues();
        double[] s = svd.getSingularValues();
        DenseMatrix64F denseMatrix64F = A = isRight ? (DenseMatrix64F)svd.getV(null, true) : (DenseMatrix64F)svd.getU(null, false);
        if (isRight) {
            if (A.numRows != svd.numCols()) {
                throw new IllegalArgumentException("Can't compute the null space using a compact SVD for a matrix of this size.");
            }
            if (nullVector == null) {
                nullVector = new DenseMatrix64F(svd.numCols(), 1);
            }
        } else {
            if (A.numCols != svd.numRows()) {
                throw new IllegalArgumentException("Can't compute the null space using a compact SVD for a matrix of this size.");
            }
            if (nullVector == null) {
                nullVector = new DenseMatrix64F(svd.numRows(), 1);
            }
        }
        int smallestIndex = -1;
        if (isRight && svd.numCols() > svd.numRows()) {
            smallestIndex = svd.numCols() - 1;
        } else if (!isRight && svd.numCols() < svd.numRows()) {
            smallestIndex = svd.numRows() - 1;
        } else {
            double smallestValue = Double.MAX_VALUE;
            int i = 0;
            while (i < N) {
                if (s[i] < smallestValue) {
                    smallestValue = s[i];
                    smallestIndex = i;
                }
                ++i;
            }
        }
        if (isRight) {
            SpecializedOps.subvector(A, smallestIndex, 0, A.numRows, true, 0, nullVector);
        } else {
            SpecializedOps.subvector(A, 0, smallestIndex, A.numRows, false, 0, nullVector);
        }
        return nullVector;
    }

    public static double singularThreshold(SingularValueDecomposition svd) {
        double largest = 0.0;
        double[] w = svd.getSingularValues();
        int N = svd.numberOfSingularValues();
        int j = 0;
        while (j < N) {
            if (w[j] > largest) {
                largest = w[j];
            }
            ++j;
        }
        int M = Math.max(svd.numCols(), svd.numRows());
        return (double)M * largest * UtilEjml.EPS;
    }

    public static int rank(SingularValueDecomposition svd) {
        double threshold = SingularOps.singularThreshold(svd);
        return SingularOps.rank(svd, threshold);
    }

    public static int rank(SingularValueDecomposition svd, double threshold) {
        int numRank = 0;
        double[] w = svd.getSingularValues();
        int N = svd.numberOfSingularValues();
        int j = 0;
        while (j < N) {
            if (w[j] > threshold) {
                ++numRank;
            }
            ++j;
        }
        return numRank;
    }

    public static int nullity(SingularValueDecomposition svd) {
        double threshold = SingularOps.singularThreshold(svd);
        return SingularOps.nullity(svd, threshold);
    }

    public static int nullity(SingularValueDecomposition svd, double threshold) {
        int ret = 0;
        double[] w = svd.getSingularValues();
        int N = svd.numberOfSingularValues();
        int numCol = svd.numCols();
        int j = 0;
        while (j < N) {
            if (w[j] <= threshold) {
                ++ret;
            }
            ++j;
        }
        return ret + numCol - N;
    }
}

