/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;

public abstract class AbstractProcessingInfo
implements IProcessingInfo {
    private List<IProcessingMessage> processingMessages = new ArrayList<IProcessingMessage>();
    private Object processingResult;

    public AbstractProcessingInfo() {
    }

    public AbstractProcessingInfo(IProcessingInfo processingInfo) {
        this();
        this.addMessages(processingInfo);
    }

    @Override
    public void addMessages(IProcessingInfo processingInfo) {
        if (processingInfo != null) {
            for (IProcessingMessage message : processingInfo.getMessages()) {
                this.addMessage(message);
            }
        }
    }

    @Override
    public void addMessage(IProcessingMessage processingMessage) {
        this.processingMessages.add(processingMessage);
    }

    @Override
    public void addInfoMessage(String description, String message) {
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.INFO, description, message);
        this.addMessage(processingMessage);
    }

    @Override
    public void addWarnMessage(String description, String message) {
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.WARN, description, message);
        this.addMessage(processingMessage);
    }

    @Override
    public void addErrorMessage(String description, String message) {
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, description, message);
        this.addMessage(processingMessage);
    }

    @Override
    public List<IProcessingMessage> getMessages() {
        return this.processingMessages;
    }

    @Override
    public void setProcessingResult(Object processingResult) {
        this.processingResult = processingResult;
    }

    @Override
    public Object getProcessingResult() {
        return this.processingResult;
    }

    @Override
    public boolean hasErrorMessages() {
        for (IProcessingMessage processingMessage : this.processingMessages) {
            if (!processingMessage.getMessageType().equals((Object)MessageType.ERROR)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasWarnMessages() {
        for (IProcessingMessage processingMessage : this.processingMessages) {
            if (!processingMessage.getMessageType().equals((Object)MessageType.WARN)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TypeCastException createTypeCastException(String description, Class<?> actual, Class<?> expected) {
        String message = "Failed to cast from " + actual + " to " + expected;
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, description, message);
        this.addMessage(processingMessage);
        return new TypeCastException(message);
    }
}

