/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.support;

import org.eclipse.swt.graphics.Color;
import org.swtchart.IAxis;
import org.swtchart.Range;

public class ChartUtil {
    public static final double MIN_RELATIVE_ABUNDANCE = 0.0;
    public static final double MAX_RELATIVE_ABUNDANCE = 1.0;

    private ChartUtil() {
    }

    public static double getRelativeAbundance(double maxSignal, double actualSignal) {
        double result = 0.0;
        if (maxSignal != 0.0) {
            result = 1.0 / maxSignal * actualSignal;
        }
        return result;
    }

    public static void setAxisColor(IAxis axis, Color color) {
        if (axis != null && color != null) {
            axis.getTitle().setForeground(color);
            axis.getTick().setForeground(color);
        }
    }

    public static synchronized void checkAndSetRange(IAxis axis, double min, double max) {
        if (axis != null) {
            Range range = axis.getRange();
            if (range.lower < min || range.lower >= max) {
                range.lower = min;
            }
            if (range.upper <= min || range.upper > max) {
                range.upper = max;
            }
            if (range.lower >= range.upper) {
                double tmp = range.upper;
                range.upper = range.lower;
                range.lower = tmp;
            }
            axis.setRange(range);
        }
    }

    public static void setRange(IAxis axis, double min, double max) {
        if (axis != null) {
            Range range = axis.getRange();
            range.lower = min;
            range.upper = max;
            if (range.lower >= range.upper) {
                double tmp = range.upper;
                range.upper = range.lower;
                range.lower = tmp;
            }
            axis.setRange(range);
        }
    }
}

