/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors;

import java.util.Map;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IPcaResult;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IPcaResults;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ISample;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors.PcaEditor;
import org.eclipse.chemclipse.thirdpartylibraries.swtchart.ext.InteractiveChartExtended;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.swtchart.ICustomPaintListener;
import org.swtchart.ILineSeries;
import org.swtchart.IPlotArea;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public class ErrorResiduePage {
    private Color COLOR_BLACK = Display.getCurrent().getSystemColor(2);
    private Color COLOR_WHITE = Display.getCurrent().getSystemColor(1);
    private Color COLOR_RED = Display.getCurrent().getSystemColor(3);
    private int SYMBOL_SIZE = 8;
    private PcaEditor pcaEditor;
    private InteractiveChartExtended errorResidueChart;

    public ErrorResiduePage(PcaEditor pcaEditor, TabFolder tabFolder, FormToolkit formToolkit) {
        this.pcaEditor = pcaEditor;
        this.initialize(tabFolder, formToolkit);
    }

    public void update() {
        if (this.errorResidueChart != null) {
            ISeries[] series;
            IPcaResults pcaResults = this.pcaEditor.getPcaResults();
            ISeriesSet seriesSet = this.errorResidueChart.getSeriesSet();
            ISeries[] iSeriesArray = series = seriesSet.getSeries();
            int n = series.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries serie = iSeriesArray[n2];
                seriesSet.deleteSeries(serie.getId());
                ++n2;
            }
            String[] fileNames = new String[pcaResults.getPcaResultMap().entrySet().size()];
            int count = 0;
            double[] errorResidue = new double[pcaResults.getPcaResultMap().size()];
            int counter = 0;
            this.errorResidueChart.getAxisSet().getXAxis(0).getTitle().setText("Sample Names");
            this.errorResidueChart.getAxisSet().getYAxis(0).getTitle().setText("Error Values(10^-6)");
            for (ISample iSample : pcaResults.getPcaResultMap().keySet()) {
                IPcaResult temp = (IPcaResult)pcaResults.getPcaResultMap().get(iSample);
                errorResidue[counter] = temp.getErrorMemberShip() * Math.pow(10.0, 6.0);
                ++counter;
            }
            for (Map.Entry entry : pcaResults.getPcaResultMap().entrySet()) {
                String name;
                fileNames[count] = name = ((ISample)entry.getKey()).getName();
                ++count;
            }
            ILineSeries iLineSeries = (ILineSeries)this.errorResidueChart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, "Samples");
            iLineSeries.setLineStyle(LineStyle.NONE);
            iLineSeries.setSymbolSize(this.SYMBOL_SIZE);
            double[] xSeries = new double[fileNames.length];
            int i = 0;
            while (i < fileNames.length) {
                xSeries[i] = i + 1;
                ++i;
            }
            iLineSeries.setYSeries(errorResidue);
            iLineSeries.setXSeries(xSeries);
            iLineSeries.setSymbolColor(this.COLOR_RED);
            iLineSeries.setSymbolType(ILineSeries.PlotSymbolType.DIAMOND);
            this.errorResidueChart.getAxisSet().getXAxis(0).setCategorySeries(fileNames);
            this.errorResidueChart.getAxisSet().getXAxis(0).enableCategory(true);
            this.errorResidueChart.getAxisSet().adjustRange();
            this.errorResidueChart.redraw();
            this.errorResidueChart.update();
        }
    }

    private void initialize(TabFolder tabFolder, FormToolkit formToolkit) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Error Residues");
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        Composite parent = new Composite(composite, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setLayoutData((Object)1808);
        Composite spinnerComposite = new Composite(parent, 0);
        spinnerComposite.setLayout((Layout)new GridLayout(5, false));
        spinnerComposite.setLayoutData((Object)new GridData(768));
        GridData gridData = new GridData();
        gridData.widthHint = 50;
        gridData.heightHint = 20;
        Composite chartComposite = new Composite(parent, 0);
        chartComposite.setLayout((Layout)new GridLayout(1, true));
        chartComposite.setLayoutData((Object)new GridData(1808));
        Button button = new Button(spinnerComposite, 8);
        button.setText("Reload Error Chart");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorResiduePage.this.update();
            }
        });
        this.errorResidueChart = new InteractiveChartExtended(chartComposite, 0);
        this.errorResidueChart.setLayoutData((Object)new GridData(1808));
        this.errorResidueChart.getTitle().setText("Error Residue Chart");
        this.errorResidueChart.getTitle().setForeground(this.COLOR_BLACK);
        this.errorResidueChart.setBackground(this.COLOR_WHITE);
        this.errorResidueChart.getLegend().setVisible(false);
        this.errorResidueChart.getAxisSet().getXAxis(0).getTitle().setText("Sample Names");
        this.errorResidueChart.getAxisSet().getXAxis(0).getTitle().setForeground(this.COLOR_BLACK);
        this.errorResidueChart.getAxisSet().getXAxis(0).getTick().setForeground(this.COLOR_BLACK);
        this.errorResidueChart.getAxisSet().getYAxis(0).getTitle().setText("Error Values(10^-6)");
        this.errorResidueChart.getAxisSet().getYAxis(0).getTitle().setForeground(this.COLOR_BLACK);
        this.errorResidueChart.getAxisSet().getYAxis(0).getTick().setForeground(this.COLOR_BLACK);
        String[] tempCategories = new String[]{" ", " ", " "};
        this.errorResidueChart.getAxisSet().getXAxis(0).setCategorySeries(tempCategories);
        this.errorResidueChart.getAxisSet().getXAxis(0).enableCategory(true);
        IPlotArea plotArea = (IPlotArea)this.errorResidueChart.getPlotArea();
        plotArea.addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                Range xRange = ErrorResiduePage.this.errorResidueChart.getAxisSet().getXAxes()[0].getRange();
                Range yRange = ErrorResiduePage.this.errorResidueChart.getAxisSet().getYAxes()[0].getRange();
                if (xRange.lower < 0.0 && xRange.upper > 0.0 && yRange.lower < 0.0 && yRange.upper > 0.0) {
                    Rectangle rectangle = ErrorResiduePage.this.errorResidueChart.getPlotArea().getClientArea();
                    int width = rectangle.width;
                    int height = rectangle.height;
                    double xDelta = xRange.upper - xRange.lower;
                    double yDelta = yRange.upper - yRange.lower;
                    double xDiff = xRange.lower * -1.0;
                    double yDiff = yRange.upper;
                    double xPart = 100.0 / xDelta * xDiff / 100.0;
                    double yPart = 100.0 / yDelta * yDiff / 100.0;
                    int xWidth = (int)((double)width * xPart);
                    int yHeight = (int)((double)height * yPart);
                    e.gc.setForeground(ErrorResiduePage.this.COLOR_BLACK);
                    e.gc.drawLine(xWidth, 0, xWidth, height);
                    e.gc.drawLine(0, yHeight, width, yHeight);
                }
            }

            public boolean drawBehindSeries() {
                return false;
            }
        });
        plotArea.addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                ISeries[] series;
                ISeriesSet seriesSet = ErrorResiduePage.this.errorResidueChart.getSeriesSet();
                ISeries[] iSeriesArray = series = seriesSet.getSeries();
                int n = series.length;
                int n2 = 0;
                while (n2 < n) {
                    ISeries serie = iSeriesArray[n2];
                    String label = serie.getId();
                    Point point = serie.getPixelCoordinates(0);
                    Point labelSize = e.gc.textExtent(label);
                    e.gc.setForeground(ErrorResiduePage.this.COLOR_BLACK);
                    e.gc.drawText("", (int)((double)point.x - (double)labelSize.x / 2.0), (int)((double)(point.y - labelSize.y) - (double)ErrorResiduePage.this.SYMBOL_SIZE / 2.0), true);
                    ++n2;
                }
            }

            public boolean drawBehindSeries() {
                return false;
            }
        });
        tabItem.setControl((Control)composite);
    }
}

