/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.ResultExport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IDataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IPcaResults;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.PcaResults;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors.ErrorResiduePage;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors.InputFilesPage;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors.OverviewPage;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors.PeakListIntensityTablePage;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors.ScorePlot3dPage;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors.ScorePlotPage;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.runnable.PcaRunnable;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.runnable.ReEvaluateRunnable;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PcaEditor {
    public static final String ID = "org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.pcaEditor";
    public static final String CONTRIBUTION_URI = "bundleclass://org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui/org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors.PcaEditor";
    public static final String ICON_URI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/chromatogram.gif";
    public static final String TOOLTIP = "PCA Editor";
    private static final Logger logger = Logger.getLogger(PcaEditor.class);
    @Inject
    private MPart part;
    @Inject
    private MDirtyable dirtyable;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    private TabFolder tabFolder;
    private FormToolkit formToolkit;
    private OverviewPage overviewPage;
    private InputFilesPage inputFilesPage;
    private PeakListIntensityTablePage peakListIntensityTablePage;
    private ScorePlotPage scorePlotPage;
    private ErrorResiduePage errorResiduePage;
    private ScorePlot3dPage scorePlot3dPage;
    private List<Object> pages;
    private File exportFile;
    private IPcaResults pcaResults = new PcaResults();

    public PcaEditor() {
        this.pages = new ArrayList<Object>();
    }

    @PostConstruct
    private void createControl(Composite parent) {
        this.createPages(parent);
    }

    @Focus
    public void setFocus() {
        this.tabFolder.setFocus();
    }

    @PreDestroy
    private void preDestroy() {
        if (this.modelService != null) {
            final MPartStack partStack = (MPartStack)this.modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)this.application);
            this.part.setToBeRendered(false);
            this.part.setVisible(false);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    partStack.getChildren().remove(PcaEditor.this.part);
                }
            });
        }
        if (this.formToolkit != null) {
            this.formToolkit.dispose();
        }
        System.gc();
    }

    @Persist
    public void save() {
        if (this.exportFile == null) {
            FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
            fileDialog.setText("Save PCA results");
            fileDialog.setOverwrite(true);
            fileDialog.setFileName("PCA-Results.txt");
            fileDialog.setFilterExtensions(new String[]{"*.txt"});
            fileDialog.setFilterNames(new String[]{"ASCII PCA reports"});
            String pathname = fileDialog.open();
            if (pathname != null) {
                this.exportFile = new File(pathname);
            }
        }
        if (this.exportFile != null) {
            try {
                ResultExport resultExport = new ResultExport();
                resultExport.exportToTextFile(this.exportFile, this.pcaResults);
                this.dirtyable.setDirty(false);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
            }
        }
    }

    public IPcaResults getPcaResults() {
        return this.pcaResults;
    }

    public void runPcaCalculation() {
        this.dirtyable.setDirty(true);
        int retentionTimeWindow = this.overviewPage.getRetentionTimeWindow();
        int numberOfPrincipleComponents = this.overviewPage.getNumberOfPrincipleComponents();
        int extractionType = this.overviewPage.getExtractionType();
        List<IDataInputEntry> dataInputEntries = this.inputFilesPage.getDataInputEntries();
        PcaRunnable runnable = new PcaRunnable(dataInputEntries, retentionTimeWindow, numberOfPrincipleComponents, extractionType);
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            monitor.run(true, true, (IRunnableWithProgress)runnable);
            this.pcaResults = runnable.getPcaResults();
            this.reloadCalculation();
            this.showScorePlotPage();
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
            logger.warn((Object)e.getCause());
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
    }

    public void reEvaluatePcaCalculation() {
        this.dirtyable.setDirty(true);
        this.pcaResults.setRetentionTimeWindow(this.overviewPage.getRetentionTimeWindow());
        this.pcaResults.setNumberOfPrincipleComponents(this.overviewPage.getNumberOfPrincipleComponents());
        this.pcaResults.setExtractionType(this.overviewPage.getExtractionType());
        ReEvaluateRunnable runnable = new ReEvaluateRunnable(this.pcaResults);
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            monitor.run(true, true, (IRunnableWithProgress)runnable);
            this.pcaResults = runnable.getPcaResults();
            this.reloadCalculation();
            this.showScorePlotPage();
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
            logger.warn((Object)e.getCause());
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
    }

    public void showInputFilesPage() {
        int pageIndex = 0;
        int index = 0;
        while (index < this.pages.size()) {
            if (this.pages.get(index) == this.inputFilesPage) {
                pageIndex = index;
            }
            ++index;
        }
        this.tabFolder.setSelection(pageIndex);
    }

    public void showScorePlotPage() {
        int pageIndex = 0;
        int index = 0;
        while (index < this.pages.size()) {
            if (this.pages.get(index) == this.scorePlotPage) {
                pageIndex = index;
            }
            ++index;
        }
        this.tabFolder.setSelection(pageIndex);
    }

    private void createPages(Composite parent) {
        this.part.setLabel("PCA");
        this.tabFolder = new TabFolder(parent, 1024);
        this.overviewPage = new OverviewPage(this, this.tabFolder, this.formToolkit);
        this.pages.add(this.overviewPage);
        this.inputFilesPage = new InputFilesPage(this, this.tabFolder, this.formToolkit);
        this.pages.add(this.inputFilesPage);
        this.peakListIntensityTablePage = new PeakListIntensityTablePage(this, this.tabFolder, this.formToolkit);
        this.pages.add(this.peakListIntensityTablePage);
        this.scorePlotPage = new ScorePlotPage(this, this.tabFolder, this.formToolkit);
        this.pages.add(this.scorePlotPage);
        this.errorResiduePage = new ErrorResiduePage(this, this.tabFolder, this.formToolkit);
        this.pages.add(this.errorResiduePage);
        this.scorePlot3dPage = new ScorePlot3dPage(this, this.tabFolder, this.formToolkit);
        this.pages.add(this.scorePlot3dPage);
    }

    private void reloadCalculation() {
        this.peakListIntensityTablePage.update();
        this.scorePlotPage.update();
        this.errorResiduePage.update();
        this.scorePlot3dPage.update();
    }
}

