/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.chemclipse.converter;

import java.io.File;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramExportConverter;
import org.eclipse.chemclipse.converter.processing.chromatogram.ChromatogramExportConverterProcessingInfo;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramExportConverterProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.chromatogram.AbstractChromatogramMSDExportConverter;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io.ChromatogramWriterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.SpecificationValidator;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramExportConverter
extends AbstractChromatogramMSDExportConverter
implements IChromatogramExportConverter {
    private static final Logger logger = Logger.getLogger(ChromatogramExportConverter.class);

    public IChromatogramExportConverterProcessingInfo convert(File file, IChromatogramMSD chromatogram, IProgressMonitor monitor) {
        ChromatogramExportConverterProcessingInfo processingInfo = new ChromatogramExportConverterProcessingInfo();
        IProcessingInfo processingInfoValidate = super.validate(file = SpecificationValidator.validateSpecification(file));
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            monitor.subTask("Export Chromatogram");
            ChromatogramWriterMSD writer = new ChromatogramWriterMSD();
            try {
                writer.writeChromatogram(file, chromatogram, monitor);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage("Export Converter", "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
            processingInfo.setFile(file);
        }
        return processingInfo;
    }
}

