/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.exceptions.QuantitationCompoundAlreadyExistsException;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationPeakMSD;

public class QuantDatabase
implements IQuantDatabase {
    private static final long serialVersionUID = 6356089588484376410L;
    private List<IQuantitationCompoundMSD> quantitationCompounds = new ArrayList<IQuantitationCompoundMSD>();
    private Map<IQuantitationCompoundMSD, List<IQuantitationPeakMSD>> quantitationCompoundPeaks = new HashMap<IQuantitationCompoundMSD, List<IQuantitationPeakMSD>>();

    @Override
    public IQuantitationCompoundMSD getQuantitationCompound(String name) {
        for (IQuantitationCompoundMSD quantitationCompound : this.quantitationCompounds) {
            if (!quantitationCompound.getName().equals(name)) continue;
            return quantitationCompound;
        }
        return null;
    }

    @Override
    public void addQuantitationCompound(IQuantitationCompoundMSD quantitationCompound) throws QuantitationCompoundAlreadyExistsException {
        String name = quantitationCompound.getName();
        if (this.getQuantitationCompound(name) != null) {
            throw new QuantitationCompoundAlreadyExistsException();
        }
        this.quantitationCompounds.add(quantitationCompound);
    }

    @Override
    public List<IQuantitationCompoundMSD> getQuantitationCompounds() {
        return this.quantitationCompounds;
    }

    @Override
    public List<String> getQuantitationCompoundNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (IQuantitationCompoundMSD quantitationCompound : this.quantitationCompounds) {
            names.add(quantitationCompound.getName());
        }
        return names;
    }

    @Override
    public String getQuantitationCompoundConcentrationUnit(String name) {
        IQuantitationCompoundMSD quantitationCompoundMSD = this.getQuantitationCompound(name);
        if (quantitationCompoundMSD != null) {
            return quantitationCompoundMSD.getConcentrationUnit();
        }
        return "";
    }

    @Override
    public long countQuantitationCompounds() {
        return this.quantitationCompounds.size();
    }

    @Override
    public boolean isQuantitationCompoundAlreadyAvailable(String name) {
        IQuantitationCompoundMSD quantitationCompoundMSD = this.getQuantitationCompound(name);
        return quantitationCompoundMSD != null;
    }

    @Override
    public void deleteQuantitationCompound(IQuantitationCompoundMSD quantitationCompound) {
        this.quantitationCompounds.remove(quantitationCompound);
    }

    @Override
    public void deleteQuantitationCompound(List<IQuantitationCompoundMSD> quantitationCompounds) {
        this.quantitationCompounds.removeAll(quantitationCompounds);
    }

    @Override
    public void deleteAllQuantitationCompounds() {
        this.quantitationCompounds.clear();
    }

    @Override
    public List<IQuantitationPeakMSD> getQuantitationPeaks(IQuantitationCompoundMSD quantitationCompound) {
        List<IQuantitationPeakMSD> quantitationPeaks = this.quantitationCompoundPeaks.get(quantitationCompound);
        if (quantitationPeaks == null) {
            quantitationPeaks = new ArrayList<IQuantitationPeakMSD>();
            this.quantitationCompoundPeaks.put(quantitationCompound, quantitationPeaks);
        }
        return quantitationPeaks;
    }

    @Override
    public void deleteQuantitationPeakDocument(IQuantitationCompoundMSD quantitationCompound, IQuantitationPeakMSD quantitationPeak) {
        List<IQuantitationPeakMSD> quantitationPeakList = this.quantitationCompoundPeaks.get(quantitationCompound);
        if (quantitationPeakList != null) {
            quantitationPeakList.remove(quantitationPeak);
        }
    }

    @Override
    public void deleteQuantitationPeakDocuments(IQuantitationCompoundMSD quantitationCompound, Set<IQuantitationPeakMSD> quantitationPeaks) {
        List<IQuantitationPeakMSD> quantitationPeakList = this.quantitationCompoundPeaks.get(quantitationCompound);
        if (quantitationPeakList != null) {
            quantitationPeakList.removeAll(quantitationPeaks);
        }
    }
}

