/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayFieldVector;
import org.apache.commons.math3.linear.FieldDecompositionSolver;
import org.apache.commons.math3.linear.FieldLUDecomposition;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;

public class AdamsNordsieckTransformer {
    private static final Map<Integer, AdamsNordsieckTransformer> CACHE = new HashMap<Integer, AdamsNordsieckTransformer>();
    private final Array2DRowRealMatrix update;
    private final double[] c1;

    private AdamsNordsieckTransformer(int nSteps) {
        FieldMatrix<BigFraction> bigP = this.buildP(nSteps);
        FieldDecompositionSolver<BigFraction> pSolver = new FieldLUDecomposition<BigFraction>(bigP).getSolver();
        Object[] u = new BigFraction[nSteps];
        Arrays.fill(u, BigFraction.ONE);
        BigFraction[] bigC1 = (BigFraction[])pSolver.solve(new ArrayFieldVector((FieldElement[])u, false)).toArray();
        FieldElement[][] shiftedP = (BigFraction[][])bigP.getData();
        int i = shiftedP.length - 1;
        while (i > 0) {
            shiftedP[i] = shiftedP[i - 1];
            --i;
        }
        shiftedP[0] = new BigFraction[nSteps];
        Arrays.fill(shiftedP[0], BigFraction.ZERO);
        FieldMatrix<BigFraction> bigMSupdate = pSolver.solve(new Array2DRowFieldMatrix(shiftedP, false));
        this.update = MatrixUtils.bigFractionMatrixToRealMatrix(bigMSupdate);
        this.c1 = new double[nSteps];
        int i2 = 0;
        while (i2 < nSteps) {
            this.c1[i2] = bigC1[i2].doubleValue();
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdamsNordsieckTransformer getInstance(int nSteps) {
        Map<Integer, AdamsNordsieckTransformer> map = CACHE;
        synchronized (map) {
            AdamsNordsieckTransformer t = CACHE.get(nSteps);
            if (t == null) {
                t = new AdamsNordsieckTransformer(nSteps);
                CACHE.put(nSteps, t);
            }
            return t;
        }
    }

    public int getNSteps() {
        return this.c1.length;
    }

    private FieldMatrix<BigFraction> buildP(int nSteps) {
        FieldElement[][] pData = new BigFraction[nSteps][nSteps];
        int i = 0;
        while (i < pData.length) {
            int factor;
            BigFraction[] pI = pData[i];
            int aj = factor = -(i + 1);
            int j = 0;
            while (j < pI.length) {
                pI[j] = new BigFraction(aj * (j + 2));
                aj *= factor;
                ++j;
            }
            ++i;
        }
        return new Array2DRowFieldMatrix(pData, false);
    }

    public Array2DRowRealMatrix initializeHighOrderDerivatives(double h, double[] t, double[][] y, double[][] yDot) {
        double[][] a = new double[2 * (y.length - 1)][this.c1.length];
        double[][] b = new double[2 * (y.length - 1)][y[0].length];
        double[] y0 = y[0];
        double[] yDot0 = yDot[0];
        int i = 1;
        while (i < y.length) {
            double di = t[i] - t[0];
            double ratio = di / h;
            double dikM1Ohk = 1.0 / h;
            double[] aI = a[2 * i - 2];
            double[] aDotI = a[2 * i - 1];
            int j = 0;
            while (j < aI.length) {
                aI[j] = di * (dikM1Ohk *= ratio);
                aDotI[j] = (double)(j + 2) * dikM1Ohk;
                ++j;
            }
            double[] yI = y[i];
            double[] yDotI = yDot[i];
            double[] bI = b[2 * i - 2];
            double[] bDotI = b[2 * i - 1];
            int j2 = 0;
            while (j2 < yI.length) {
                bI[j2] = yI[j2] - y0[j2] - di * yDot0[j2];
                bDotI[j2] = yDotI[j2] - yDot0[j2];
                ++j2;
            }
            ++i;
        }
        QRDecomposition decomposition = new QRDecomposition(new Array2DRowRealMatrix(a, false));
        RealMatrix x = decomposition.getSolver().solve(new Array2DRowRealMatrix(b, false));
        return new Array2DRowRealMatrix(x.getData(), false);
    }

    public Array2DRowRealMatrix updateHighOrderDerivativesPhase1(Array2DRowRealMatrix highOrder) {
        return this.update.multiply(highOrder);
    }

    public void updateHighOrderDerivativesPhase2(double[] start, double[] end, Array2DRowRealMatrix highOrder) {
        double[][] data = highOrder.getDataRef();
        int i = 0;
        while (i < data.length) {
            double[] dataI = data[i];
            double c1I = this.c1[i];
            int j = 0;
            while (j < dataI.length) {
                int n = j;
                dataI[n] = dataI[n] + c1I * (start[j] - end[j]);
                ++j;
            }
            ++i;
        }
    }
}

