/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.core;

import org.eclipse.chemclipse.chromatogram.filter.processing.ChromatogramFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.processing.IChromatogramFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.IChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.AbstractChromatogramFilterMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.exceptions.FilterException;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.settings.ISupplierFilterSettings;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramFilter
extends AbstractChromatogramFilterMSD {
    private IMarkedIons ionsToRemove;

    public IChromatogramFilterProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        ChromatogramFilterResult chromatogramFilterResult;
        ChromatogramFilterProcessingInfo processingInfo = new ChromatogramFilterProcessingInfo();
        processingInfo.addMessages(this.validate(chromatogramSelection, chromatogramFilterSettings));
        if (processingInfo.hasErrorMessages()) {
            return processingInfo;
        }
        this.setFilterSettings(chromatogramFilterSettings);
        try {
            this.applyIonRemoverFilter(chromatogramSelection, monitor);
            chromatogramFilterResult = new ChromatogramFilterResult(ResultStatus.OK, "Mass fragments have been removed successfully.");
        }
        catch (FilterException e) {
            chromatogramFilterResult = new ChromatogramFilterResult(ResultStatus.EXCEPTION, e.getMessage());
        }
        processingInfo.setChromatogramFilterResult((IChromatogramFilterResult)chromatogramFilterResult);
        return processingInfo;
    }

    public IChromatogramFilterProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) {
        IChromatogramFilterSettings chromatogramFilterSettings = PreferenceSupplier.getChromatogramFilterSettings();
        return this.applyFilter(chromatogramSelection, chromatogramFilterSettings, monitor);
    }

    private void setFilterSettings(IChromatogramFilterSettings chromatogramFilterSettings) {
        if (chromatogramFilterSettings instanceof ISupplierFilterSettings) {
            ISupplierFilterSettings settings = (ISupplierFilterSettings)chromatogramFilterSettings;
            this.ionsToRemove = settings.getIonsToRemove();
        }
    }

    private void applyIonRemoverFilter(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) throws FilterException {
        if (this.ionsToRemove == null) {
            throw new FilterException("The excluded ions instance was null.");
        }
        if (this.ionsToRemove.getIonsNominal().size() == 0) {
            throw new FilterException("There was no ion stored to be excluded.");
        }
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        int scan = startScan;
        while (scan <= stopScan) {
            monitor.subTask("Remove ions from scan: " + scan);
            IVendorMassSpectrum supplierMassSpectrum = chromatogram.getSupplierScan(scan);
            supplierMassSpectrum.removeIons(this.ionsToRemove);
            ++scan;
        }
    }
}

