/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.support;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.process.model.IChromatogramProcessEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.BaselineDetectorTypeSupplier;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.ChromatogramCalculatorTypeSupplier;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.ChromatogramFilterTypeSupplier;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.ChromatogramIdentifierTypeSupplier;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.ChromatogramIntegratorTypeSupplier;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.ChromatogramMSDFilterTypeSupplier;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.ClassifierTypeSupplier;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.CombinedIntegratorTypeSupplier;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.PeakDetectorTypeSupplier;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.PeakFilterTypeSupplier;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.PeakIdentifierTypeSupplier;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.PeakIntegratorTypeSupplier;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.PeakQuantitationTypeSupplier;
import org.eclipse.chemclipse.chromatogram.msd.process.support.IProcessTypeSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProcessTypeSupport {
    private static final Logger logger = Logger.getLogger(ProcessTypeSupport.class);
    private List<IProcessTypeSupplier> processTypeSuppliers = new ArrayList<IProcessTypeSupplier>();

    public ProcessTypeSupport() {
        this.processTypeSuppliers.add(new BaselineDetectorTypeSupplier());
        this.processTypeSuppliers.add(new ChromatogramIdentifierTypeSupplier());
        this.processTypeSuppliers.add(new ChromatogramIntegratorTypeSupplier());
        this.processTypeSuppliers.add(new ClassifierTypeSupplier());
        this.processTypeSuppliers.add(new CombinedIntegratorTypeSupplier());
        this.processTypeSuppliers.add(new ChromatogramFilterTypeSupplier());
        this.processTypeSuppliers.add(new ChromatogramMSDFilterTypeSupplier());
        this.processTypeSuppliers.add(new PeakFilterTypeSupplier());
        this.processTypeSuppliers.add(new PeakDetectorTypeSupplier());
        this.processTypeSuppliers.add(new PeakIdentifierTypeSupplier());
        this.processTypeSuppliers.add(new PeakIntegratorTypeSupplier());
        this.processTypeSuppliers.add(new PeakQuantitationTypeSupplier());
        this.processTypeSuppliers.add(new ChromatogramCalculatorTypeSupplier());
    }

    public String[] getProcessorNames(String processCategory, String[] processorIds) {
        int size = processorIds.length;
        String[] processorNames = new String[size];
        int index = 0;
        while (index < size) {
            processorNames[index] = this.getProcessorName(processCategory, processorIds[index]);
            ++index;
        }
        return processorNames;
    }

    public String getProcessorName(IChromatogramProcessEntry entry) {
        return this.getProcessorName(entry.getProcessCategory(), entry.getProcessorId());
    }

    public String getProcessorName(String processCategory, String processorId) {
        String processorName = "n.a.";
        for (IProcessTypeSupplier processTypeSupplier : this.processTypeSuppliers) {
            if (!processTypeSupplier.getCategory().equals(processCategory)) continue;
            try {
                processorName = processTypeSupplier.getProcessorName(processorId);
                return processorName;
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
        return processorName;
    }

    public String[] getProcessorCategories() {
        String[] processorNames = new String[this.processTypeSuppliers.size()];
        int index = 0;
        for (IProcessTypeSupplier processTypeSupplier : this.processTypeSuppliers) {
            processorNames[index] = processTypeSupplier.getCategory();
            ++index;
        }
        return processorNames;
    }

    public String[] getPluginIds(String processCategory) {
        String[] pluginIds = new String[]{"n.a."};
        for (IProcessTypeSupplier processTypeSupplier : this.processTypeSuppliers) {
            if (!processTypeSupplier.getCategory().equals(processCategory)) continue;
            try {
                pluginIds = processTypeSupplier.getPluginIds().toArray(new String[0]);
                return pluginIds;
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
        return pluginIds;
    }

    public IProcessingInfo applyProcessor(IChromatogramSelectionMSD chromatogramSelection, IChromatogramProcessEntry processEntry, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        for (IProcessTypeSupplier processTypeSupplier : this.processTypeSuppliers) {
            if (!processTypeSupplier.getCategory().equals(processEntry.getProcessCategory())) continue;
            return processTypeSupplier.applyProcessor(chromatogramSelection, processEntry.getProcessorId(), monitor);
        }
        processingInfo.addErrorMessage("Process Type Support", "There was now supplier to process the chromatogram selection.");
        return processingInfo;
    }
}

