/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.io.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.chemclipse.converter.io.streams.DataInputStream;
import org.eclipse.chemclipse.converter.io.support.IArrayReader;
import org.eclipse.chemclipse.logging.core.Logger;

public abstract class AbstractArrayReader
implements IArrayReader {
    private static final Logger logger = Logger.getLogger(AbstractArrayReader.class);
    private int position;
    private byte[] data;
    private int length;

    public AbstractArrayReader(byte[] data) {
        this.initialize(data);
    }

    public AbstractArrayReader(File file) throws FileNotFoundException, IOException {
        byte[] data = this.getByteArrayFromFile(file);
        this.initialize(data);
    }

    private byte[] getByteArrayFromFile(File file) throws FileNotFoundException, IOException {
        int length = (int)file.length();
        byte[] data = new byte[length];
        DataInputStream is = new DataInputStream(file);
        is.read(data);
        is.close();
        return data;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    private void initialize(byte[] data) {
        this.position = 0;
        this.data = data;
        this.length = data.length;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void increasePosition() {
        ++this.position;
    }

    @Override
    public void decreasePosition() {
        --this.position;
    }

    @Override
    public void resetPosition() {
        this.position = 0;
    }

    @Override
    public void seek(int position) {
        if (position > 0) {
            this.resetPosition();
            this.skipBytes(position);
        }
    }

    @Override
    public byte readByte() {
        return this.data[this.position++];
    }

    @Override
    public byte[] readBytes(int i) {
        return this.getByteArray(i);
    }

    @Override
    public byte[] readBytes(byte[] prefix, int i) {
        return this.getByteArray(prefix, i);
    }

    @Override
    public void skipBytes(int i) {
        this.position += i;
    }

    @Override
    public short read1BUShortLE() {
        return (short)this.readULongLE(1);
    }

    @Override
    public int read2BUIntegerLE() {
        return (int)this.readULongLE(2);
    }

    @Override
    public long read4BULongLE() {
        return this.readULongLE(4);
    }

    @Override
    public long read8BULongLE() {
        return this.readULongLE(8);
    }

    @Override
    public float read4BUFloatLE() {
        return Float.intBitsToFloat((int)this.read4BULongLE());
    }

    @Override
    public short read1BShortLE() {
        return this.readByte();
    }

    @Override
    public short read2BShortLE() {
        return (short)this.readLongLE(2);
    }

    @Override
    public int read2BIntegerLE() {
        return this.read2BShortLE();
    }

    @Override
    public int read4BIntegerLE() {
        return (int)this.readLongLE(4);
    }

    @Override
    public long read4BLongLE() {
        return this.read4BIntegerLE();
    }

    @Override
    public long read8BLongLE() {
        return this.readLongLE(8);
    }

    @Override
    public float read4BFloatLE() {
        return Float.intBitsToFloat(this.read4BIntegerLE());
    }

    @Override
    public long readULongLE(int numBytes) {
        long value = this.readLongLE(numBytes);
        return value & Long.MAX_VALUE;
    }

    @Override
    public long readLongLE(int numBytes) {
        assert (numBytes <= 8) : "The number of bytes needs to be lower than 8";
        if (numBytes <= 0 || numBytes > 8) {
            return 0L;
        }
        byte[] tmp = this.getByteArray(numBytes);
        long result = 0L;
        int shift = 0;
        int i = 0;
        while (i < numBytes) {
            result |= ((long)tmp[i] & 0xFFL) << shift;
            shift += 8;
            ++i;
        }
        return result;
    }

    @Override
    public double read8BUDoubleLE() {
        return Double.longBitsToDouble(this.read8BULongLE());
    }

    @Override
    public double read8BDoubleLE() {
        return Double.longBitsToDouble(this.read8BLongLE());
    }

    @Override
    public short read1BUShortBE() {
        return (short)this.readULongBE(1);
    }

    @Override
    public int read2BUIntegerBE() {
        return (int)this.readULongBE(2);
    }

    @Override
    public long read4BULongBE() {
        return this.readULongBE(4);
    }

    @Override
    public long read8BULongBE() {
        return this.readULongBE(8);
    }

    @Override
    public short read1BShortBE() {
        return this.readByte();
    }

    @Override
    public short read2BShortBE() {
        return (short)this.readLongBE(2);
    }

    @Override
    public int read2BIntegerBE() {
        return this.read2BShortBE();
    }

    @Override
    public int read4BIntegerBE() {
        return (int)this.readLongBE(4);
    }

    @Override
    public long read4BLongBE() {
        return this.read4BIntegerBE();
    }

    @Override
    public long read8BLongBE() {
        return this.readLongBE(8);
    }

    @Override
    public long readULongBE(int numBytes) {
        long value = this.readLongBE(numBytes);
        return value & Long.MAX_VALUE;
    }

    @Override
    public long readLongBE(int numBytes) {
        assert (numBytes <= 8) : "The number of bytes needs to be lower than 8";
        if (numBytes <= 0 || numBytes > 8) {
            return 0L;
        }
        byte[] tmp = this.getByteArray(numBytes);
        long result = 0L;
        int shift = (numBytes - 1) * 8;
        int i = 0;
        while (i < numBytes) {
            result |= ((long)tmp[i] & 0xFFL) << shift;
            shift -= 8;
            ++i;
        }
        return result;
    }

    @Override
    public float read4BFloatBE() {
        return Float.intBitsToFloat(this.read4BIntegerBE());
    }

    @Override
    public double read8BUDoubleBE() {
        return Double.longBitsToDouble(this.read8BULongBE());
    }

    @Override
    public double read8BDoubleBE() {
        return Double.longBitsToDouble(this.read8BLongBE());
    }

    @Override
    public int read4BUIntegerME() {
        byte[] tmp = this.getByteArray(4);
        return (tmp[0] & 0xFF) << 16 | (tmp[1] & 0x7F) << 24 | tmp[2] & 0xFF | (tmp[3] & 0xFF) << 8;
    }

    @Override
    public long read4BULongME() {
        byte[] tmp = this.getByteArray(4);
        return ((long)tmp[0] & 0xFFL) << 16 | ((long)tmp[1] & 0xFFL) << 24 | (long)tmp[2] & 0xFFL | ((long)tmp[3] & 0xFFL) << 8;
    }

    @Override
    public String readBytesAsStringWithLengthIndex(int readBytes) {
        byte[] tmp = new byte[readBytes];
        byte length = this.data[this.position++];
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < readBytes) {
            tmp[i] = this.data[this.position++];
            ++i;
        }
        i = 0;
        while (i < length) {
            bytes[i] = tmp[i];
            ++i;
        }
        return new String(bytes).trim();
    }

    @Override
    public String readBytesAsString(int readBytes) {
        return new String(this.getByteArray(readBytes));
    }

    private byte[] getByteArray(int count) {
        byte[] tmp = new byte[count];
        int i = 0;
        while (i < count) {
            tmp[i] = this.data[this.position++];
            ++i;
        }
        return tmp;
    }

    private byte[] getByteArray(byte[] prefix, int count) {
        byte[] tmp = new byte[prefix.length + count];
        int i = 0;
        int j = 0;
        while (j < prefix.length) {
            tmp[i++] = prefix[j];
            ++j;
        }
        j = 0;
        while (j < count) {
            tmp[i++] = this.data[this.position++];
            ++j;
        }
        return tmp;
    }

    @Override
    public String readString(int readBytes) {
        StringBuilder builder = new StringBuilder();
        int i = 1;
        while (i <= readBytes) {
            byte value = this.readByte();
            if (value > 0) {
                builder.append((char)value);
            }
            ++i;
        }
        return builder.toString();
    }

    @Override
    public String readString(int readBytes, String charsetName) {
        byte[] data = new byte[readBytes];
        int i = 0;
        while (i < readBytes) {
            data[i] = this.readByte();
            ++i;
        }
        String result = "";
        try {
            result = new String(data, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Object)e);
        }
        return result;
    }
}

