/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.swt;

import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;

public class OverviewIntegrationResultsUI
extends Composite {
    public static final String POPUP_MENU_ID = "org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.swt.overviewIntegrationResultsUI.popup";
    private List list;
    private Clipboard clipboard;

    public OverviewIntegrationResultsUI(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void update(double chromatogramArea, double backgroundArea, double peakArea) {
        this.list.removeAll();
        this.list.add("Chromatogram Area: " + chromatogramArea);
        this.list.add("Background Area: " + backgroundArea);
        this.list.add("Peak Area: " + peakArea);
    }

    private void initialize() {
        this.clipboard = new Clipboard(Display.getDefault());
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.list = new List(composite, 2818);
        this.list.add("There are no integration results available.");
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.list.setLayoutData((Object)gridData);
        this.list.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    OverviewIntegrationResultsUI.this.copyToClipboard();
                }
            }
        });
        this.initContextMenu();
    }

    private void initContextMenu() {
        MenuManager menuManager = new MenuManager("#PopUpMenu", POPUP_MENU_ID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        OverviewIntegrationResultsUI.this.copyToClipboard();
                    }
                };
                action.setText("Copy selection to clipboard");
                manager.add((IAction)action);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.list);
        this.list.setMenu(menu);
    }

    private void copyToClipboard() {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = this.list.getSelection();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String selection = stringArray[n2];
            builder.append(selection);
            builder.append(OperatingSystemUtils.getLineDelimiter());
            ++n2;
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        Object[] data = new Object[]{builder.toString()};
        Transfer[] dataTypes = new Transfer[]{textTransfer};
        this.clipboard.setContents(data, dataTypes);
    }
}

