/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.jcampdx.model;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.converter.supplier.jcampdx.model.IVendorLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.AbstractRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;

public class VendorLibraryMassSpectrum
extends AbstractRegularLibraryMassSpectrum
implements IVendorLibraryMassSpectrum {
    private static final long serialVersionUID = -888313765380340368L;
    private static final Logger logger = Logger.getLogger(VendorLibraryMassSpectrum.class);

    public IVendorLibraryMassSpectrum makeDeepCopy() throws CloneNotSupportedException {
        IVendorLibraryMassSpectrum massSpectrum = (IVendorLibraryMassSpectrum)super.clone();
        for (IIon ion : this.getIons()) {
            try {
                Ion jcampIon = new Ion(ion.getIon(), ion.getAbundance());
                massSpectrum.addIon((IIon)jcampIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        return massSpectrum;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.makeDeepCopy();
    }
}

