/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.MatrixIO;

public class DenseMatrix64F
extends RowD1Matrix64F {
    public DenseMatrix64F(int numRows, int numCols, boolean rowMajor, double ... data) {
        int length = numRows * numCols;
        this.data = new double[length];
        this.numRows = numRows;
        this.numCols = numCols;
        this.set(numRows, numCols, rowMajor, data);
    }

    public DenseMatrix64F(double[][] data) {
        this.numRows = data.length;
        this.numCols = data[0].length;
        this.data = new double[this.numRows * this.numCols];
        int pos = 0;
        int i = 0;
        while (i < this.numRows) {
            double[] row = data[i];
            if (row.length != this.numCols) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            System.arraycopy(row, 0, this.data, pos, this.numCols);
            pos += this.numCols;
            ++i;
        }
    }

    public DenseMatrix64F(int numRows, int numCols) {
        this.data = new double[numRows * numCols];
        this.numRows = numRows;
        this.numCols = numCols;
    }

    public DenseMatrix64F(DenseMatrix64F orig) {
        this(orig.numRows, orig.numCols);
        System.arraycopy(orig.data, 0, this.data, 0, orig.getNumElements());
    }

    public DenseMatrix64F(int length) {
        this.data = new double[length];
    }

    public DenseMatrix64F() {
    }

    public DenseMatrix64F(RealMatrix64F mat) {
        this(mat.getNumRows(), mat.getNumCols());
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.numCols) {
                this.set(i, j, mat.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public static DenseMatrix64F wrap(int numRows, int numCols, double[] data) {
        DenseMatrix64F s = new DenseMatrix64F();
        s.data = data;
        s.numRows = numRows;
        s.numCols = numCols;
        return s;
    }

    @Override
    public void reshape(int numRows, int numCols, boolean saveValues) {
        if (this.data.length < numRows * numCols) {
            double[] d = new double[numRows * numCols];
            if (saveValues) {
                System.arraycopy(this.data, 0, d, 0, this.getNumElements());
            }
            this.data = d;
        }
        this.numRows = numRows;
        this.numCols = numCols;
    }

    @Override
    public void set(int row, int col, double value) {
        if (col < 0 || col >= this.numCols || row < 0 || row >= this.numRows) {
            throw new IllegalArgumentException("Specified element is out of bounds: (" + row + " , " + col + ")");
        }
        this.data[row * this.numCols + col] = value;
    }

    @Override
    public void unsafe_set(int row, int col, double value) {
        this.data[row * this.numCols + col] = value;
    }

    public void add(int row, int col, double value) {
        if (col < 0 || col >= this.numCols || row < 0 || row >= this.numRows) {
            throw new IllegalArgumentException("Specified element is out of bounds");
        }
        int n = row * this.numCols + col;
        this.data[n] = this.data[n] + value;
    }

    @Override
    public double get(int row, int col) {
        if (col < 0 || col >= this.numCols || row < 0 || row >= this.numRows) {
            throw new IllegalArgumentException("Specified element is out of bounds: " + row + " " + col);
        }
        return this.data[row * this.numCols + col];
    }

    @Override
    public double unsafe_get(int row, int col) {
        return this.data[row * this.numCols + col];
    }

    @Override
    public int getIndex(int row, int col) {
        return row * this.numCols + col;
    }

    public boolean isInBounds(int row, int col) {
        return col >= 0 && col < this.numCols && row >= 0 && row < this.numRows;
    }

    @Override
    public int getNumElements() {
        return this.numRows * this.numCols;
    }

    public void set(int numRows, int numCols, boolean rowMajor, double ... data) {
        this.reshape(numRows, numCols);
        int length = numRows * numCols;
        if (length > this.data.length) {
            throw new IllegalArgumentException("The length of this matrix's data array is too small.");
        }
        if (rowMajor) {
            System.arraycopy(data, 0, this.data, 0, length);
        } else {
            int index = 0;
            int i = 0;
            while (i < numRows) {
                int j = 0;
                while (j < numCols) {
                    this.data[index++] = data[j * numRows + i];
                    ++j;
                }
                ++i;
            }
        }
    }

    public void zero() {
        Arrays.fill(this.data, 0, this.getNumElements(), 0.0);
    }

    public DenseMatrix64F copy() {
        return new DenseMatrix64F(this);
    }

    @Override
    public void set(Matrix original) {
        RealMatrix64F m = (RealMatrix64F)original;
        this.reshape(original.getNumRows(), original.getNumCols());
        if (original instanceof DenseMatrix64F) {
            System.arraycopy(((DenseMatrix64F)m).data, 0, this.data, 0, this.numRows * this.numCols);
        } else {
            int index = 0;
            int i = 0;
            while (i < this.numRows) {
                int j = 0;
                while (j < this.numCols) {
                    this.data[index++] = m.get(i, j);
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public void print() {
        MatrixIO.print(System.out, this);
    }

    public void print(String format) {
        MatrixIO.print(System.out, this, format);
    }

    public String toString() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        MatrixIO.print(new PrintStream(stream), this);
        return stream.toString();
    }
}

