/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.support;

import org.eclipse.chemclipse.model.support.IBackgroundAbundanceRange;

public class BackgroundAbundanceRange
implements IBackgroundAbundanceRange {
    private float startBackgroundAbundance;
    private float stopBackgroundAbundance;

    public BackgroundAbundanceRange(float startBackgroundAbundance, float stopBackgroundAbundance) {
        if (startBackgroundAbundance < 0.0f || startBackgroundAbundance > Float.MAX_VALUE) {
            startBackgroundAbundance = 0.0f;
        }
        if (stopBackgroundAbundance > Float.MAX_VALUE || stopBackgroundAbundance < 0.0f) {
            stopBackgroundAbundance = Float.MAX_VALUE;
        }
        this.startBackgroundAbundance = startBackgroundAbundance;
        this.stopBackgroundAbundance = stopBackgroundAbundance;
    }

    @Override
    public float getStartBackgroundAbundance() {
        return this.startBackgroundAbundance;
    }

    @Override
    public float getStopBackgroundAbundance() {
        return this.stopBackgroundAbundance;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        BackgroundAbundanceRange otherRange = (BackgroundAbundanceRange)other;
        return this.getStartBackgroundAbundance() == otherRange.getStartBackgroundAbundance() && this.getStopBackgroundAbundance() == otherRange.getStopBackgroundAbundance();
    }

    public int hashCode() {
        return 7 * Float.valueOf(this.getStartBackgroundAbundance()).hashCode() + 11 * Float.valueOf(this.getStopBackgroundAbundance()).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("startBackgroundAbundance=" + this.getStartBackgroundAbundance());
        builder.append(",");
        builder.append("stopBackgroundAbundance=" + this.getStopBackgroundAbundance());
        builder.append("]");
        return builder.toString();
    }
}

