/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.identifier.supplier.manual.ui.internal.wizards;

import org.eclipse.chemclipse.chromatogram.xxd.identifier.supplier.manual.ui.internal.wizards.IdentificationPage;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.PeakComparisonResult;
import org.eclipse.chemclipse.model.identifier.PeakLibraryInformation;
import org.eclipse.chemclipse.model.targets.IPeakTarget;
import org.eclipse.chemclipse.model.targets.PeakTarget;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class IdentificationWizard
extends Wizard {
    private static final Logger logger = Logger.getLogger(IdentificationWizard.class);
    private static final float FACTOR = 100.0f;
    private IdentificationPage identificationPage;
    private IPeak peak;

    public IdentificationWizard(IPeak peak) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Peak Identification");
        this.peak = peak;
    }

    public void addPages() {
        this.identificationPage = new IdentificationPage("Manual Peak Identification");
        this.addPage((IWizardPage)this.identificationPage);
    }

    public boolean performFinish() {
        block7: {
            PeakTarget peakTarget;
            block6: {
                this.removeErrorMessage();
                String name = this.identificationPage.getIdentificationName();
                if (this.peak == null) {
                    this.showErrorMessage("There is no peak selected.");
                    return false;
                }
                if (name == null || name.equals("")) {
                    this.showErrorMessage("Please select a name to identify the peak.");
                    return false;
                }
                String casNumber = this.identificationPage.getCasNumber();
                String comments = this.identificationPage.getComments();
                String formula = this.identificationPage.getFormula();
                double molWeight = this.identificationPage.getMolWeight();
                PeakLibraryInformation libraryInformation = new PeakLibraryInformation();
                libraryInformation.setName(name);
                libraryInformation.setCasNumber(casNumber);
                libraryInformation.setComments(comments);
                libraryInformation.setFormula(formula);
                libraryInformation.setMolWeight(molWeight);
                try {
                    PeakComparisonResult comparisonResult = new PeakComparisonResult(100.0f, 100.0f, 100.0f, 100.0f, 100.0f);
                    peakTarget = new PeakTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                    peakTarget.setIdentifier("Manual Peak Identifier");
                    if (!(this.peak instanceof IChromatogramPeakMSD)) break block6;
                    ((IChromatogramPeakMSD)this.peak).addTarget((IPeakTarget)peakTarget);
                    return true;
                }
                catch (ReferenceMustNotBeNullException e) {
                    logger.warn((Object)e);
                    return false;
                }
            }
            if (!(this.peak instanceof IChromatogramPeakCSD)) break block7;
            ((IChromatogramPeakCSD)this.peak).addTarget((IPeakTarget)peakTarget);
            return true;
        }
        this.showErrorMessage("The peak is no instance of IChromatogramPeakMSD or IChromatogramPeakCSD.");
        return false;
    }

    private void showErrorMessage(String message) {
        this.identificationPage.setErrorMessage(message);
    }

    private void removeErrorMessage() {
        this.identificationPage.setErrorMessage(null);
    }
}

