/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt.IQuantitationCompoundUpdater;
import org.eclipse.chemclipse.model.quantitation.CalibrationMethod;
import org.eclipse.chemclipse.msd.model.core.quantitation.IConcentrationResponseEntriesMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IConcentrationResponseEntryMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.IEquation;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.series.ISeriesSetter;
import org.eclipse.chemclipse.swt.ui.series.MultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.Series;
import org.eclipse.chemclipse.swt.ui.support.ChartUtil;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.chemclipse.thirdpartylibraries.swtchart.ext.InteractiveChartExtended;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.IAxis;
import org.swtchart.IAxisSet;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public class ConcentrationResponseEntriesLineSeriesUI
extends InteractiveChartExtended
implements ISeriesSetter,
IQuantitationCompoundUpdater,
KeyListener,
MouseListener {
    private IMultipleSeries multipleLineSeries;
    private IAxis yAxisLeft;
    private IAxis xAxisBottom;
    private IAxis yAxisRight;
    private IAxis xAxisTop;
    private double maxSignal = 0.0;
    private IQuantitationCompoundMSD quantitationCompoundMSD;

    public ConcentrationResponseEntriesLineSeriesUI(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    @Override
    public void update(IQuantitationCompoundMSD quantitationCompoundMSD, IQuantDatabase database) {
        if (quantitationCompoundMSD == null || database == null) {
            this.setConcentrationLabel("");
            this.deleteAllCurrentSeries();
        } else {
            this.quantitationCompoundMSD = quantitationCompoundMSD;
            this.setViewSeries();
        }
    }

    public void setViewSeries() {
        if (this.quantitationCompoundMSD != null) {
            ILineSeries lineSeries;
            this.deleteAllCurrentSeries();
            this.setConcentrationLabel(this.quantitationCompoundMSD.getConcentrationUnit());
            IConcentrationResponseEntriesMSD concentrationResponseEntriesMSD = this.quantitationCompoundMSD.getConcentrationResponseEntriesMSD();
            this.maxSignal = concentrationResponseEntriesMSD.getMaxResponseValue();
            CalibrationMethod calibrationMethod = this.quantitationCompoundMSD.getCalibrationMethod();
            boolean useCrossZero = this.quantitationCompoundMSD.isCrossZero();
            String colorSchemeOverlay = PreferenceSupplier.getColorSchemeOverlay();
            IColorScheme colorScheme = Colors.getColorScheme((String)colorSchemeOverlay);
            IMultipleSeries multipleSeries = this.getSeries(concentrationResponseEntriesMSD);
            for (ISeries series : multipleSeries.getMultipleSeries()) {
                this.addSeries(series);
                lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                lineSeries.setXSeries(series.getXSeries());
                lineSeries.setYSeries(series.getYSeries());
                lineSeries.enableArea(false);
                lineSeries.setSymbolType(ILineSeries.PlotSymbolType.CIRCLE);
                lineSeries.setSymbolColor(colorScheme.getColor());
                lineSeries.setLineStyle(LineStyle.NONE);
                colorScheme.incrementColor();
            }
            colorScheme.reset();
            double xExtra = multipleSeries.getXMax() / 20.0;
            double yExtra = multipleSeries.getYMax() / 20.0;
            double xMin = 0.0;
            double yMin = 0.0;
            double xMax = multipleSeries.getXMax() + xExtra;
            double yMax = multipleSeries.getYMax() + yExtra;
            Point pointMin = new Point(xMin, yMin);
            Point pointMax = new Point(xMax, yMax);
            multipleSeries = this.getSeriesByEquation(concentrationResponseEntriesMSD, calibrationMethod, useCrossZero, pointMin, pointMax);
            for (ISeries series : multipleSeries.getMultipleSeries()) {
                this.addSeries(series);
                lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                lineSeries.setXSeries(series.getXSeries());
                lineSeries.setYSeries(series.getYSeries());
                lineSeries.enableArea(false);
                if (calibrationMethod.equals((Object)CalibrationMethod.AVERAGE)) {
                    lineSeries.setSymbolType(ILineSeries.PlotSymbolType.CROSS);
                    lineSeries.setSymbolColor(colorScheme.getColor());
                    lineSeries.setLineStyle(LineStyle.NONE);
                } else if (calibrationMethod.equals((Object)CalibrationMethod.QUADRATIC)) {
                    lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
                    lineSeries.setLineStyle(LineStyle.SOLID);
                    lineSeries.setLineColor(colorScheme.getColor());
                } else {
                    lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
                    lineSeries.setLineStyle(LineStyle.SOLID);
                    lineSeries.setLineColor(colorScheme.getColor());
                }
                colorScheme.incrementColor();
            }
            this.getAxisSet().adjustRange();
            this.redraw();
        }
    }

    private IMultipleSeries getSeries(IConcentrationResponseEntriesMSD concentrationResponseEntriesMSD) {
        MultipleSeries concentrationResponseSeries = new MultipleSeries();
        Set ions = concentrationResponseEntriesMSD.getIonSet();
        Iterator iterator = ions.iterator();
        while (iterator.hasNext()) {
            double ion = (Double)iterator.next();
            List list = concentrationResponseEntriesMSD.getList(ion);
            double[] xSeries = new double[list.size()];
            double[] ySeries = new double[list.size()];
            int x = 0;
            int y = 0;
            for (IConcentrationResponseEntryMSD concentrationResponseEntry : list) {
                xSeries[x++] = concentrationResponseEntry.getConcentration();
                ySeries[y++] = concentrationResponseEntry.getResponse();
            }
            String label = ion == 0.0 ? "TIC" : "m/z " + Double.valueOf(ion).toString();
            concentrationResponseSeries.add((ISeries)new Series(xSeries, ySeries, label));
        }
        return concentrationResponseSeries;
    }

    private IMultipleSeries getSeriesByEquation(IConcentrationResponseEntriesMSD concentrationResponseEntriesMSD, CalibrationMethod calibrationMethod, boolean useCrossZero, Point pointMin, Point pointMax) {
        MultipleSeries equationSeries = new MultipleSeries();
        Set ions = concentrationResponseEntriesMSD.getIonSet();
        Iterator iterator = ions.iterator();
        while (iterator.hasNext()) {
            double ion = (Double)iterator.next();
            String label = ion == 0.0 ? "TIC" : "m/z " + Double.valueOf(ion).toString();
            Series series = null;
            switch (calibrationMethod) {
                case LINEAR: {
                    LinearEquation equation;
                    label = String.valueOf(label) + " eq";
                    try {
                        equation = concentrationResponseEntriesMSD.getLinearEquation(ion, useCrossZero);
                        if (equation.getA() < 0.0) {
                            throw new Exception();
                        }
                        series = this.calculateLinearEquationSeries((IEquation)equation, useCrossZero, pointMin, pointMax, label);
                    }
                    catch (Exception exception) {
                        series = this.getErrorEquationSeries(label);
                    }
                    break;
                }
                case QUADRATIC: {
                    LinearEquation equation;
                    label = String.valueOf(label) + " eq^2";
                    try {
                        equation = concentrationResponseEntriesMSD.getQuadraticEquation(ion, useCrossZero);
                        series = this.calculateQuadraticEquationSeries((IEquation)equation, useCrossZero, pointMin, pointMax, label);
                    }
                    catch (Exception exception) {
                        series = this.getErrorEquationSeries(label);
                    }
                    break;
                }
                case AVERAGE: {
                    label = String.valueOf(label) + " avg";
                    try {
                        List entries = concentrationResponseEntriesMSD.getList(ion);
                        series = this.calculateAverageSeries(entries, label);
                        break;
                    }
                    catch (Exception exception) {
                        series = this.getErrorEquationSeries(label);
                    }
                }
            }
            if (series == null) continue;
            equationSeries.add(series);
        }
        return equationSeries;
    }

    private Series getErrorEquationSeries(String label) {
        double[] xSeries = new double[]{0.0};
        double[] ySeries = new double[]{0.0};
        return new Series(xSeries, ySeries, String.valueOf(label) + " (Error)");
    }

    private Series calculateLinearEquationSeries(IEquation equation, boolean useCrossZero, Point pointMin, Point pointMax, String label) {
        double y;
        double[] xSeries = new double[2];
        double[] ySeries = new double[2];
        double xMax = pointMax.getX();
        double yMax = pointMax.getY();
        double x = equation.calculateX(yMax);
        if (x > xMax) {
            y = equation.calculateY(xMax);
            x = xMax;
        } else {
            y = equation.calculateY(x);
        }
        if (useCrossZero) {
            xSeries[0] = 0.0;
            ySeries[0] = 0.0;
        } else {
            xSeries[0] = pointMin.getX();
            ySeries[0] = pointMin.getY();
        }
        xSeries[1] = x;
        ySeries[1] = y;
        return new Series(xSeries, ySeries, label);
    }

    private Series calculateQuadraticEquationSeries(IEquation equation, boolean useCrossZero, Point pointMin, Point pointMax, String label) {
        int steps = 50;
        double xStart = useCrossZero ? 0.0 : pointMin.getX();
        double xStep = (pointMax.getX() - xStart) / (double)steps;
        ArrayList<Point> points = new ArrayList<Point>();
        double x = xStart;
        while (x < pointMax.getX()) {
            double y = equation.calculateY(x);
            if (y > 0.0) {
                points.add(new Point(x, y));
            }
            x += xStep;
        }
        double[] xSeries = new double[points.size()];
        double[] ySeries = new double[points.size()];
        int index = 0;
        while (index < points.size()) {
            IPoint point = (IPoint)points.get(index);
            xSeries[index] = point.getX();
            ySeries[index] = point.getY();
            ++index;
        }
        return new Series(xSeries, ySeries, label);
    }

    private Series calculateAverageSeries(List<IConcentrationResponseEntryMSD> entries, String label) {
        double x = 0.0;
        double y = 0.0;
        int size = entries.size();
        if (size == 0) {
            return null;
        }
        for (IConcentrationResponseEntryMSD entry : entries) {
            x += entry.getConcentration();
            y += entry.getResponse();
        }
        double[] xSeries = new double[]{x /= (double)size};
        double[] ySeries = new double[]{y /= (double)size};
        return new Series(xSeries, ySeries, label);
    }

    private void initialize() {
        this.getPlotArea().addKeyListener((KeyListener)this);
        this.getPlotArea().addMouseListener((MouseListener)this);
        this.multipleLineSeries = new MultipleSeries();
        this.getLegend().setVisible(false);
        this.getTitle().setVisible(false);
        this.createPrimaryAxes();
        this.createSecondaryAxes();
        this.setAxesAndBackgroundColors();
        this.getAxisSet().adjustRange();
    }

    private void createPrimaryAxes() {
        IAxisSet axisSet = this.getAxisSet();
        this.yAxisLeft = axisSet.getYAxis(0);
        this.yAxisLeft.getTitle().setText("Response");
        this.yAxisLeft.setPosition(IAxis.Position.Primary);
        this.xAxisBottom = axisSet.getXAxis(0);
        this.xAxisBottom.getTitle().setText("Concentration");
        this.xAxisBottom.setPosition(IAxis.Position.Primary);
    }

    private void createSecondaryAxes() {
        IAxisSet axisSet = this.getAxisSet();
        int axisIdTop = axisSet.createXAxis();
        this.xAxisTop = axisSet.getXAxis(axisIdTop);
        this.xAxisTop.getTitle().setText("Concentration");
        this.xAxisTop.setPosition(IAxis.Position.Secondary);
        int axisIdAbundanceRelative = axisSet.createYAxis();
        this.yAxisRight = axisSet.getYAxis(axisIdAbundanceRelative);
        this.yAxisRight.getTitle().setText("Relative Response");
        this.yAxisRight.setPosition(IAxis.Position.Secondary);
    }

    private void setConcentrationLabel(String concentrationUnit) {
        this.xAxisTop.getTitle().setText("Concentration (" + concentrationUnit + ")");
        this.xAxisBottom.getTitle().setText("Concentration (" + concentrationUnit + ")");
    }

    private void setAxesAndBackgroundColors() {
        assert (this.yAxisLeft != null) : "The abundance instance must be not null.";
        assert (this.xAxisBottom != null) : "The concentration instance must be not null.";
        assert (this.yAxisRight != null) : "The relativeAbundance instance must be not null.";
        assert (this.xAxisTop != null) : "The top instance must be not null.";
        this.setBackground(Colors.WHITE);
        this.setBackgroundInPlotArea(Colors.WHITE);
        ChartUtil.setAxisColor((IAxis)this.yAxisLeft, (Color)Colors.BLACK);
        ChartUtil.setAxisColor((IAxis)this.xAxisBottom, (Color)Colors.BLACK);
        ChartUtil.setAxisColor((IAxis)this.yAxisRight, (Color)Colors.BLACK);
        ChartUtil.setAxisColor((IAxis)this.xAxisTop, (Color)Colors.BLACK);
    }

    protected void deleteAllCurrentSeries() {
        this.multipleLineSeries.removeAll();
        org.swtchart.ISeries[] series = this.getSeriesSet().getSeries();
        ArrayList<String> ids = new ArrayList<String>();
        org.swtchart.ISeries[] iSeriesArray = series;
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            org.swtchart.ISeries serie = iSeriesArray[n2];
            ids.add(serie.getId());
            ++n2;
        }
        for (String id : ids) {
            this.getSeriesSet().deleteSeries(id);
        }
    }

    public void addSeries(ISeries series) {
        if (this.multipleLineSeries != null) {
            this.multipleLineSeries.add(series);
        }
    }

    public synchronized void redraw() {
        super.redraw();
        double xMin = this.multipleLineSeries.getXMin();
        double xMax = this.multipleLineSeries.getXMax();
        double yMin = this.multipleLineSeries.getYMin();
        double yMax = this.multipleLineSeries.getYMax();
        if (xMin < xMax && yMin < yMax) {
            ChartUtil.checkAndSetRange((IAxis)this.xAxisBottom, (double)xMin, (double)xMax);
            ChartUtil.checkAndSetRange((IAxis)this.yAxisLeft, (double)yMin, (double)yMax);
            this.redrawXAxisBottomScale();
            this.redrawYAxisRightScale();
        }
    }

    public void redrawXAxisBottomScale() {
        assert (this.xAxisTop != null) : "The xAxisTop instance must be not null.";
        assert (this.xAxisBottom != null) : "The xAxisBottom instance must be not null.";
        Range range = this.xAxisBottom.getRange();
        double min = range.lower;
        double max = range.upper;
        ChartUtil.setRange((IAxis)this.xAxisTop, (double)min, (double)max);
    }

    public void redrawYAxisRightScale() {
        assert (this.yAxisLeft != null) : "The yAxisLeft instance must be not null.";
        assert (this.yAxisRight != null) : "The yAxisRight instance must be not null.";
        Range range = this.yAxisLeft.getRange();
        double min = ChartUtil.getRelativeAbundance((double)this.maxSignal, (double)range.lower);
        double max = ChartUtil.getRelativeAbundance((double)this.maxSignal, (double)range.upper);
        ChartUtil.setRange((IAxis)this.yAxisRight, (double)min, (double)max);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }
}

