/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.map.SimpleMapProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoMapProperty<S, K, V>
extends SimpleMapProperty<S, K, V> {
    private final PropertyDescriptor propertyDescriptor;
    private final Class<K> keyType;
    private final Class<V> valueType;

    public PojoMapProperty(PropertyDescriptor propertyDescriptor, Class<K> keyType, Class<V> valueType) {
        this.propertyDescriptor = propertyDescriptor;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public Object getKeyType() {
        return this.keyType;
    }

    public Object getValueType() {
        return this.valueType;
    }

    public Class<K> getKeyClass() {
        return this.keyType;
    }

    public Class<V> getValueClass() {
        return this.valueType;
    }

    protected Map<K, V> doGetMap(S source) {
        return this.asMap(BeanPropertyHelper.readProperty(source, this.propertyDescriptor));
    }

    private Map<?, ?> asMap(Object propertyValue) {
        if (propertyValue == null) {
            return Collections.emptyMap();
        }
        return (Map)propertyValue;
    }

    protected void doSetMap(S source, Map<K, V> map, MapDiff<K, V> diff) {
        this.doSetMap(source, map);
    }

    protected void doSetMap(S source, Map<K, V> map) {
        BeanPropertyHelper.writeProperty(source, this.propertyDescriptor, map);
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<MapDiff<K, V>> listener) {
        return null;
    }

    public String toString() {
        String s = String.valueOf(BeanPropertyHelper.propertyName(this.propertyDescriptor)) + "{:}";
        if (this.keyType != null || this.valueType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(this.keyType) + ", " + BeanPropertyHelper.shortClassName(this.valueType) + ">";
        }
        return s;
    }
}

