/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.core;

import org.eclipse.chemclipse.chromatogram.msd.classifier.core.AbstractChromatogramClassifier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.exceptions.ChromatogramSelectionException;
import org.eclipse.chemclipse.chromatogram.msd.classifier.exceptions.ClassifierSettingsException;
import org.eclipse.chemclipse.chromatogram.msd.classifier.processing.ChromatogramClassifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.classifier.processing.IChromatogramClassifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.classifier.result.IChromatogramClassifierResult;
import org.eclipse.chemclipse.chromatogram.msd.classifier.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.msd.classifier.settings.IChromatogramClassifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.exceptions.ClassifierException;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.internal.core.support.Calculator;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.IWncIons;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.WncIons;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.result.WncClassifierResult;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.settings.IWncClassifierSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramResult;
import org.eclipse.chemclipse.model.implementation.ChromatogramResult;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class Classifier
extends AbstractChromatogramClassifier {
    private static final Logger logger = Logger.getLogger(Classifier.class);
    private IWncIons wncIons;

    public IChromatogramClassifierProcessingInfo applyClassifier(IChromatogramSelectionMSD chromatogramSelection, IChromatogramClassifierSettings chromatogramClassifierSettings, IProgressMonitor monitor) {
        ChromatogramClassifierProcessingInfo processingInfo = new ChromatogramClassifierProcessingInfo();
        try {
            this.validate(chromatogramSelection, chromatogramClassifierSettings);
            this.setClassifierSettings(chromatogramClassifierSettings);
            try {
                Calculator calculator = new Calculator();
                IWncIons resultWncIons = calculator.calculateIonPercentages(chromatogramSelection, this.wncIons);
                WncClassifierResult chromatogramClassifierResult = new WncClassifierResult(ResultStatus.OK, "The chromatogram has been classified.", resultWncIons);
                ChromatogramResult chromatogramResult = new ChromatogramResult("org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc", "This is percentage area list of selected ions.", (Object)this.wncIons);
                chromatogramSelection.getChromatogram().addChromatogramResult((IChromatogramResult)chromatogramResult);
                processingInfo.setChromatogramClassifierResult((IChromatogramClassifierResult)chromatogramClassifierResult);
            }
            catch (ClassifierException classifierException) {
                ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "WNC Classifier", "The chromatogram couldn't be classified.");
                processingInfo.addMessage((IProcessingMessage)processingMessage);
            }
        }
        catch (ChromatogramSelectionException e1) {
            logger.warn((Object)e1);
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "WNC Classifier", "The chromatogram selection is invalid.");
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        catch (ClassifierSettingsException e1) {
            logger.warn((Object)e1);
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "WNC Classifier", "The settings are invalid.");
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        return processingInfo;
    }

    public IChromatogramClassifierProcessingInfo applyClassifier(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) {
        IChromatogramClassifierSettings chromatogramClassifierSettings = PreferenceSupplier.getChromatogramClassifierSettings();
        return this.applyClassifier(chromatogramSelection, chromatogramClassifierSettings, monitor);
    }

    private void setClassifierSettings(IChromatogramClassifierSettings chromatogramClassifierSettings) {
        if (chromatogramClassifierSettings instanceof IWncClassifierSettings) {
            IWncClassifierSettings settings = (IWncClassifierSettings)chromatogramClassifierSettings;
            this.wncIons = settings.getWNCIons();
        } else {
            this.wncIons = new WncIons();
        }
    }
}

