/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.breakpoints.ValidBreakpointLocationLocator;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class BreakpointLocationVerifierJob
extends Job {
    private IJavaLineBreakpoint fBreakpoint;
    private int fLineNumber;
    private String fTypeName;
    private IType fType;
    private IEditorPart fEditorPart;
    CompilationUnit fCunit = null;
    private IDocument fDocument = null;
    private IEditorStatusLine fStatusLine;
    private boolean fBestMatch = false;

    public BreakpointLocationVerifierJob(IDocument document, CompilationUnit cunit, IJavaLineBreakpoint breakpoint, int lineNumber, String typeName, IType type, IEditorPart editorPart, boolean bestmatch) {
        super(ActionMessages.BreakpointLocationVerifierJob_breakpoint_location);
        this.fCunit = cunit;
        this.fDocument = document;
        this.fBreakpoint = breakpoint;
        this.fLineNumber = lineNumber;
        this.fTypeName = typeName;
        this.fType = type;
        this.fEditorPart = editorPart;
        this.fBestMatch = bestmatch;
        this.fStatusLine = (IEditorStatusLine)editorPart.getAdapter(IEditorStatusLine.class);
        this.setSystem(true);
    }

    public IStatus run(IProgressMonitor monitor) {
        ValidBreakpointLocationLocator locator = new ValidBreakpointLocationLocator(this.fCunit, this.fLineNumber, true, this.fBestMatch);
        this.fCunit.accept((ASTVisitor)locator);
        int lineNumber = locator.getLineLocation();
        String typeName = locator.getFullyQualifiedTypeName();
        try {
            switch (locator.getLocationType()) {
                case 1: {
                    return this.manageLineBreakpoint(typeName, lineNumber);
                }
                case 2: {
                    if (this.fBreakpoint != null) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    }
                    new ToggleBreakpointAdapter().toggleMethodBreakpoints((IWorkbenchPart)this.fEditorPart, (ISelection)new TextSelection(locator.getMemberOffset(), 0));
                    break;
                }
                case 3: {
                    if (this.fBreakpoint != null) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    }
                    new ToggleBreakpointAdapter().toggleWatchpoints((IWorkbenchPart)this.fEditorPart, (ISelection)new TextSelection(locator.getMemberOffset(), 0));
                    break;
                }
                default: {
                    this.report(ActionMessages.BreakpointLocationVerifierJob_not_valid_location);
                    if (this.fBreakpoint != null) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    }
                    return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
                }
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpoint_set, null);
    }

    public IStatus manageLineBreakpoint(String typeName, int lineNumber) {
        try {
            boolean breakpointExist;
            boolean differentLineNumber = lineNumber != this.fLineNumber;
            IJavaLineBreakpoint breakpoint = JDIDebugModel.lineBreakpointExists((IResource)this.fBreakpoint.getMarker().getResource(), (String)typeName, (int)lineNumber);
            boolean bl = breakpointExist = breakpoint != null;
            if (this.fBreakpoint == null) {
                if (breakpointExist) {
                    if (differentLineNumber) {
                        this.report(NLS.bind((String)ActionMessages.BreakpointLocationVerifierJob_0, (Object[])new String[]{Integer.toString(lineNumber)}));
                        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
                    }
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
                    return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpointRemoved, null);
                }
                this.createNewBreakpoint(lineNumber, typeName);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpoint_set, null);
            }
            if (differentLineNumber) {
                if (breakpointExist) {
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    this.report(NLS.bind((String)ActionMessages.BreakpointLocationVerifierJob_0, (Object[])new String[]{Integer.toString(lineNumber)}));
                    return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
                }
                this.replaceBreakpoint(lineNumber, typeName);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 2, ActionMessages.BreakpointLocationVerifierJob_breakpointMovedToValidPosition, null);
            }
            if (!typeName.equals(this.fTypeName)) {
                this.replaceBreakpoint(lineNumber, typeName);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 2, ActionMessages.BreakpointLocationVerifierJob_breakpointSetToRightType, null);
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpoint_set, null);
    }

    private void replaceBreakpoint(int lineNumber, String typeName) throws CoreException {
        this.createNewBreakpoint(lineNumber, typeName);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
    }

    private void createNewBreakpoint(int lineNumber, String typeName) throws CoreException {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>(10);
        int start = -1;
        int end = -1;
        if (this.fType != null) {
            try {
                IRegion line = this.fDocument.getLineInformation(lineNumber - 1);
                start = line.getOffset();
                end = start + line.getLength();
            }
            catch (BadLocationException ble) {
                JDIDebugUIPlugin.log(ble);
            }
            BreakpointUtils.addJavaBreakpointAttributes(newAttributes, (IJavaElement)this.fType);
        }
        JDIDebugModel.createLineBreakpoint((IResource)this.fBreakpoint.getMarker().getResource(), (String)typeName, (int)lineNumber, (int)start, (int)end, (int)0, (boolean)true, newAttributes);
    }

    protected void report(final String message) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BreakpointLocationVerifierJob.this.fStatusLine != null) {
                    BreakpointLocationVerifierJob.this.fStatusLine.setMessage(true, message, null);
                }
            }
        });
    }
}

