/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.wsd.ui.internal.support;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.converter.core.ISupplier;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramExportConverterProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.wsd.converter.chromatogram.ChromatogramConverterWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ChromatogramExportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(ChromatogramExportRunnable.class);
    private File data;
    private File file;
    private IChromatogramWSD chromatogram;
    private ISupplier supplier;

    public ChromatogramExportRunnable(File file, IChromatogramWSD chromatogram, ISupplier supplier) {
        this.file = file;
        this.chromatogram = chromatogram;
        this.supplier = supplier;
    }

    public File getData() {
        return this.data;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Export Chromatogram", -1);
            IChromatogramExportConverterProcessingInfo processingInfo = ChromatogramConverterWSD.convert((File)this.file, (IChromatogramWSD)this.chromatogram, (String)this.supplier.getId(), (IProgressMonitor)new SubProgressMonitor(monitor, -1));
            try {
                this.data = processingInfo.getFile();
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
        finally {
            monitor.done();
        }
    }
}

