/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.ui.internal.preferences;

import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.IWncIon;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.WncIon;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WncIonDialog
extends TitleAreaDialog {
    private static final Logger logger = Logger.getLogger(WncIonDialog.class);
    private String title = "WNC Ion";
    private String message = "Add a ion that shall be analyzed.";
    private Text textName;
    private Text textIon;
    private IWncIon wncIon;

    public WncIonDialog(Shell shell) {
        this(shell, null);
    }

    public WncIonDialog(Shell shell, IWncIon wncIon) {
        super(shell);
        this.wncIon = wncIon;
    }

    public IWncIon getWNCIon() {
        return this.wncIon;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.title);
        this.setMessage(this.message, 1);
        return contents;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            try {
                int ion = this.getIon();
                String name = this.getName();
                this.wncIon = new WncIon(ion, name);
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite elementComposite = new Composite(composite, 4);
        elementComposite.setLayout((Layout)new GridLayout(1, true));
        GridData gridData = new GridData(512);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 400;
        elementComposite.setLayoutData((Object)gridData);
        Label labelName = new Label(elementComposite, 0);
        labelName.setLayoutData((Object)gridData);
        labelName.setText("Name (not allowed characters are \":\" and \";\"):");
        GridData gridDataText = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridDataText.widthHint = 300;
        this.textName = new Text(elementComposite, 2048);
        this.textName.setLayoutData((Object)gridDataText);
        if (this.wncIon != null) {
            this.textName.setText(this.wncIon.getName());
        }
        this.textName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                WncIonDialog.this.validate();
            }
        });
        Label labelIon = new Label(elementComposite, 0);
        labelIon.setText("ion:");
        this.textIon = new Text(elementComposite, 2048);
        if (this.wncIon != null) {
            this.textIon.setText(Integer.valueOf(this.wncIon.getIon()).toString());
        }
        this.textIon.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                WncIonDialog.this.validate();
            }
        });
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        return control;
    }

    private void validate() {
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(true);
        String name = this.getName();
        if (name.equals("")) {
            this.setErrorMessage("A name must be specified.");
            this.getButton(0).setEnabled(false);
        }
        try {
            this.getIon();
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage("The ion value must be an integer, e.g. 18 or 28.");
            this.getButton(0).setEnabled(false);
        }
    }

    private int getIon() throws NumberFormatException {
        int ion = Integer.valueOf(this.textIon.getText());
        return ion;
    }

    private String getName() {
        return this.textName.getText().trim();
    }
}

