/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.core.ISupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.core.ISupportSetter;
import org.eclipse.chemclipse.chromatogram.msd.identifier.exceptions.NoIdentifierAvailableException;

public abstract class AbstractSupport
implements ISupportSetter {
    private List<ISupplier> suppliers = new ArrayList<ISupplier>();

    @Override
    public void add(ISupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public String getIdentifierId(int index) throws NoIdentifierAvailableException {
        this.areIdentifiersStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoIdentifierAvailableException("There is no identifier stored.");
        }
        ISupplier supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String[] getIdentifierNames() throws NoIdentifierAvailableException {
        this.areIdentifiersStored();
        ArrayList<String> identifierNames = new ArrayList<String>();
        for (ISupplier supplier : this.suppliers) {
            identifierNames.add(supplier.getIdentifierName());
        }
        return identifierNames.toArray(new String[identifierNames.size()]);
    }

    @Override
    public List<String> getAvailableIdentifierIds() throws NoIdentifierAvailableException {
        this.areIdentifiersStored();
        ArrayList<String> availableIdentifiers = new ArrayList<String>();
        for (ISupplier supplier : this.suppliers) {
            availableIdentifiers.add(supplier.getId());
        }
        if (availableIdentifiers.isEmpty()) {
            throw new NoIdentifierAvailableException("There is no appropriate identifier available.");
        }
        return availableIdentifiers;
    }

    @Override
    public ISupplier getIdentifierSupplier(String identifierId) throws NoIdentifierAvailableException {
        ISupplier identifierSupplier = null;
        this.areIdentifiersStored();
        if (identifierId == null || identifierId.equals("")) {
            throw new NoIdentifierAvailableException("There is no identifier supplier available with the following id: " + identifierId + ".");
        }
        for (ISupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(identifierId)) continue;
            identifierSupplier = supplier;
            break;
        }
        if (identifierSupplier == null) {
            throw new NoIdentifierAvailableException("There is no identifier supplier available with the following id: " + identifierId + ".");
        }
        return identifierSupplier;
    }

    private void areIdentifiersStored() throws NoIdentifierAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoIdentifierAvailableException();
        }
    }
}

