/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.handlers;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.chemclipse.support.ui.wizards.ChromatogramWizardElements;
import org.eclipse.chemclipse.support.ui.wizards.IChromatogramWizardElements;
import org.eclipse.chemclipse.ux.extension.msd.ui.support.ChromatogramSupport;
import org.eclipse.chemclipse.ux.extension.msd.ui.wizards.ChromatogramInputEntriesWizard;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class OpenHandler {
    @Inject
    private EPartService partService;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;

    @Execute
    public void execute(@Named(value="activeShell") Shell shell) {
        List selectedChromatograms;
        ChromatogramWizardElements chromatogramWizardElements = new ChromatogramWizardElements();
        ChromatogramInputEntriesWizard inputWizard = new ChromatogramInputEntriesWizard((IChromatogramWizardElements)chromatogramWizardElements);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)inputWizard);
        wizardDialog.create();
        if (wizardDialog.open() == 0 && (selectedChromatograms = chromatogramWizardElements.getSelectedChromatograms()).size() > 0) {
            for (String chromatogram : selectedChromatograms) {
                File file = new File(chromatogram);
                ChromatogramSupport.getInstanceEditorSupport().openEditor(file, this.modelService, this.application, this.partService);
            }
        }
    }
}

