/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.notifier.IMassSpectrumSelectionUpdateNotifier;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.provider.MassSpectrumTargetsContentProvider;
import org.eclipse.chemclipse.ux.extension.ui.views.AbstractTargetsView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class MassSpectrumTargetsView
extends AbstractTargetsView
implements IMassSpectrumSelectionUpdateNotifier {
    @Inject
    private Composite parent;
    @Inject
    private EPartService partService;
    @Inject
    private MPart part;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;
    private IScanMSD massSpectrum;
    private Map<String, Object> map;

    @Inject
    public MassSpectrumTargetsView(IEventBroker eventBroker) {
        super((IStructuredContentProvider)new MassSpectrumTargetsContentProvider(), eventBroker);
        this.eventBroker = eventBroker;
        this.map = new HashMap<String, Object>();
    }

    @PostConstruct
    private void createControl() {
        super.createPartControl(this.parent);
        this.subscribe();
        TableViewer tableViewer = this.getTableViewer();
        tableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode != 127 && e.stateMask == 0) {
                    MassSpectrumTargetsView.this.propagateSelectedTargetAndMassSpectrum();
                }
            }
        });
        tableViewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                MassSpectrumTargetsView.this.propagateSelectedTargetAndMassSpectrum();
            }
        });
    }

    @Focus
    public void setFocus() {
        super.setFocus();
        this.update(this.massSpectrum, false);
    }

    public void update(IScanMSD massSpectrum, boolean forceReload) {
        if (this.doUpdate(massSpectrum)) {
            super.update((Object)massSpectrum, forceReload);
            this.getTableViewer().getTable().setSelection(0);
            this.propagateSelectedTargetAndMassSpectrum();
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    MassSpectrumTargetsView.this.massSpectrum = (IScanMSD)event.getProperty("MassSpectrum");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    MassSpectrumTargetsView.this.update(MassSpectrumTargetsView.this.massSpectrum, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/msd/update/massspectrum", this.eventHandler);
        }
    }

    private void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }

    private boolean doUpdate(IScanMSD massSpectrum) {
        return this.isPartVisible() && massSpectrum != null;
    }

    private boolean isPartVisible() {
        return this.partService != null && this.partService.isPartVisible(this.part);
    }

    private void propagateSelectedTargetAndMassSpectrum() {
        TableItem tableItem;
        Object object;
        Table table = this.getTableViewer().getTable();
        int index = table.getSelectionIndex();
        if (index >= 0 && (object = (tableItem = table.getItem(index)).getData()) instanceof IIdentificationTarget) {
            IIdentificationTarget identificationTarget = (IIdentificationTarget)object;
            this.map.clear();
            this.map.put("MassSpectrumUnknown", this.massSpectrum);
            this.map.put("IdentificationTarget", identificationTarget);
            this.eventBroker.send("identification/target/update/massspectrum/unknown", this.map);
        }
    }
}

