/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.peak.PeakQuantitationEntriesUI;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.AbstractChromatogramSelectionMSDView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PeakQuantitationEntriesView
extends AbstractChromatogramSelectionMSDView {
    @Inject
    private Composite parent;
    private PeakQuantitationEntriesUI peakQuantitationEntriesUI;

    @Inject
    public PeakQuantitationEntriesView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
    }

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.peakQuantitationEntriesUI = new PeakQuantitationEntriesUI(this.parent, 0);
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.peakQuantitationEntriesUI.setFocus();
        this.update(this.getChromatogramSelection(), false);
    }

    @Override
    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        IChromatogramPeakMSD peak;
        if (this.doUpdate((IChromatogramSelection)chromatogramSelection) && (peak = chromatogramSelection.getSelectedPeak()) != null) {
            this.peakQuantitationEntriesUI.update((IPeakMSD)peak, true);
        }
    }

    @Override
    public boolean doUpdate(IChromatogramSelection chromatogramSelection) {
        if (super.doUpdate(chromatogramSelection) && chromatogramSelection instanceof IChromatogramSelectionMSD) {
            return ((IChromatogramSelectionMSD)chromatogramSelection).getSelectedPeak() != null;
        }
        return false;
    }
}

