/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.PropertySecurity;
import org.eclipse.birt.data.engine.odaconsumer.Driver;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;

public class DriverManager {
    private static DriverManager sm_driverManager = null;
    private Hashtable<String, Driver> m_loadedDrivers;
    private static final String sm_className = DriverManager.class.getName();
    private static LogHelper sm_logger;

    private DriverManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DriverManager getInstance() {
        if (sm_driverManager != null) return sm_driverManager;
        Class<DriverManager> clazz = DriverManager.class;
        synchronized (DriverManager.class) {
            if (sm_driverManager != null) return sm_driverManager;
            sm_driverManager = new DriverManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_driverManager;
        }
    }

    static void releaseInstance() {
        sm_driverManager = null;
        sm_logger = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LogHelper getLogger() {
        if (sm_logger != null) return sm_logger;
        Class<DriverManager> clazz = DriverManager.class;
        synchronized (DriverManager.class) {
            if (sm_logger != null) return sm_logger;
            sm_logger = LogHelper.getInstance("org.eclipse.birt.data.engine.odaconsumer");
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_logger;
        }
    }

    public IDriver getDriverHelper(String dataSourceElementId) throws DataException {
        return this.getDriverHelper(dataSourceElementId, true, null);
    }

    IDriver getNewDriverHelper(String dataSourceElementId, Map<?, ?> appContext) throws DataException {
        return this.getDriverHelper(dataSourceElementId, false, appContext);
    }

    private IDriver getDriverHelper(String dataSourceElementId, boolean reuseExisting, Map<?, ?> appContext) throws DataException {
        DriverManager.getLogger().entering(sm_className, "getDriverHelper(String,boolean,Map)", new Object[]{dataSourceElementId, reuseExisting});
        Driver driver = this.getDriver(dataSourceElementId);
        IDriver ret = reuseExisting ? driver.getDriverHelper() : driver.createNewDriverHelper(appContext);
        DriverManager.getLogger().exiting(sm_className, "getDriverHelper(String,boolean,Map)", ret);
        return ret;
    }

    public String getExtensionDataSourceId(String dataSourceElementId) throws DataException {
        DriverManager.getLogger().entering(sm_className, "getExtensionDataSourceId", dataSourceElementId);
        Driver driver = this.getDriver(dataSourceElementId);
        ExtensionManifest config = driver.getDriverExtensionConfig();
        String ret = config.getDataSourceElementID();
        DriverManager.getLogger().exiting(sm_className, "getExtensionDataSourceId", ret);
        return ret;
    }

    private Driver getDriver(String dataSourceElementId) {
        assert (dataSourceElementId != null && dataSourceElementId.length() != 0);
        Driver driver = this.getLoadedDrivers().get(dataSourceElementId);
        if (driver == null) {
            driver = new Driver(dataSourceElementId);
            this.getLoadedDrivers().put(dataSourceElementId, driver);
        }
        return driver;
    }

    Hashtable<String, Driver> getLoadedDrivers() {
        if (this.m_loadedDrivers == null) {
            this.m_loadedDrivers = PropertySecurity.createHashtable();
        }
        return this.m_loadedDrivers;
    }
}

