/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.data.convert;

import org.eclipse.nebula.widgets.nattable.data.convert.NumericDisplayConverter;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public abstract class DecimalNumericDisplayConverter
extends NumericDisplayConverter {
    public DecimalNumericDisplayConverter() {
        this.nf.setMinimumFractionDigits(1);
        this.nf.setMaximumFractionDigits(2);
    }

    @Override
    public Object canonicalToDisplayValue(Object canonicalValue) {
        try {
            if (ObjectUtils.isNotNull(canonicalValue)) {
                return this.nf.format(canonicalValue);
            }
            return null;
        }
        catch (Exception exception) {
            return canonicalValue;
        }
    }

    public void setMinimumFractionDigits(int newValue) {
        this.nf.setMinimumFractionDigits(newValue);
    }

    public void setMaximumFractionDigits(int newValue) {
        this.nf.setMaximumFractionDigits(newValue);
    }
}

