/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.chromatogram;

import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.swt.ui.components.chromatogram.AbstractViewMSDChromatogramUI;
import org.eclipse.chemclipse.msd.swt.ui.converter.SeriesConverterMSD;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public class SelectedNominalIonChromatogramUI
extends AbstractViewMSDChromatogramUI {
    public SelectedNominalIonChromatogramUI(Composite parent, int style) {
        super(parent, style);
    }

    public void setViewSeries() {
        IChromatogramSelectionMSD chromatogramSelection;
        IMarkedIons selectedIons;
        IChromatogramSelection storedChromatogramSelection = this.getChromatogramSelection();
        if (storedChromatogramSelection instanceof IChromatogramSelectionMSD && (selectedIons = (chromatogramSelection = (IChromatogramSelectionMSD)storedChromatogramSelection).getSelectedIons()) != null && selectedIons.size() > 0) {
            IMultipleSeries multipleSeries = SeriesConverterMSD.convertChromatogram(chromatogramSelection, selectedIons, false, Sign.POSITIVE);
            int size = multipleSeries.getMultipleSeries().size();
            String colorSchemeOverlay = PreferenceSupplier.getColorSchemeOverlay();
            IColorScheme colorScheme = Colors.getColorScheme((String)colorSchemeOverlay);
            int i = 0;
            while (i < size) {
                ISeries series = (ISeries)multipleSeries.getMultipleSeries().get(i);
                this.setAdditionalIonSeries(series, colorScheme.getColor());
                colorScheme.incrementColor();
                ++i;
            }
        }
    }

    private void setAdditionalIonSeries(ISeries series, Color color) {
        this.addSeries(series);
        ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(true);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(color);
    }
}

